using System;
using System.Configuration;
using System.Collections.Generic;
using System.Web;
using System.Web.Configuration;
using System.Linq;
using System.Web.Services;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.ServiceModel.Activation;
using VIRP;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;
using VIRP.AHOBPR.BLL;
using VIRP.AHOBPR.BO;

namespace VIRP_SERVICE
{
	[WebService(Namespace = "http://DNS")]
	[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
	[WebServiceBindingAttribute(Name = "CrsServices", Namespace = "http://DNS")]
	[ServiceContract(Name = "CrsServices", Namespace = "http://DNS")]
	[System.ComponentModel.ToolboxItem(false)]
	[AspNetCompatibilityRequirements(RequirementsMode = AspNetCompatibilityRequirementsMode.Allowed)]
	[ServiceBehavior(InstanceContextMode = InstanceContextMode.Single)]
	public partial class CrsServices : System.Web.Services.WebService
	{
        #region BCCCR_BCR_ALL

        [WebMethod]
        public List<BCCCR_BCR_ALL> BCCCR_BCR_ALL_GET_ALL_BY_SEARCH(string identity, int registryId, short sta3n, string patientSearch)
        {
            return VIRPManager.BCCCR_BCR_ALL_GET_ALL_BY_SEARCH(identity, registryId, sta3n, patientSearch);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/BCCCR_BCR_ALL_GET_ALL_BY_SEARCH?identity={identity}&registryId={registryId}&sta3n={sta3n}&patientSearch={patientSearch}")]
        public List<BCCCR_BCR_ALL> BCCCR_BCR_ALL_GET_ALL_BY_SEARCH_XML(string identity, int registryId, short sta3n, string patientSearch)
        {
            return this.BCCCR_BCR_ALL_GET_ALL_BY_SEARCH(identity, registryId, sta3n, patientSearch);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/BCCCR_BCR_ALL_GET_ALL_BY_SEARCH?identity={identity}&registryId={registryId}&sta3n={sta3n}&patientSearch={patientSearch}")]
        public List<BCCCR_BCR_ALL> BCCCR_BCR_ALL_GET_ALL_BY_SEARCH_JSON(string identity, int registryId, short sta3n, string patientSearch)
        {
            return this.BCCCR_BCR_ALL_GET_ALL_BY_SEARCH(identity, registryId, sta3n, patientSearch);
        }

        #endregion

        #region DATA_DICTIONARY

        [WebMethod]
        public List<DATA_DICTIONARY> DATA_DICTIONARY_GET_ALL(string identity, int registryId)
        {
            return VIRPManager.DATA_DICTIONARY_GET_ALL(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/DATA_DICTIONARY_GET_ALL?identity={identity}&registryId={registryId}")]
        public List<DATA_DICTIONARY> DATA_DICTIONARY_GET_ALL_XML(string identity, int registryId)
        {
            return this.DATA_DICTIONARY_GET_ALL(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/DATA_DICTIONARY_GET_ALL?identity={identity}&registryId={registryId}")]
        public List<DATA_DICTIONARY> DATA_DICTIONARY_GET_ALL_JSON(string identity, int registryId)
        {
            return this.DATA_DICTIONARY_GET_ALL(identity, registryId);
        }

        #endregion

        #region DB_LOG

        [WebMethod]
        public int DB_LOG_SAVE(string identity, int registryId, DB_LOG objSave)
        {
            return VIRPManager.DB_LOG_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/DB_LOG_SAVE?identity={identity}&registryId={registryId}")]
        public int DB_LOG_SAVE_XML(string identity, int registryId, DB_LOG objSave)
        {
            return this.DB_LOG_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/DB_LOG_SAVE?identity={identity}&registryId={registryId}")]
        public int DB_LOG_SAVE_JSON(string identity, int registryId, DB_LOG objSave)
        {
            return this.DB_LOG_SAVE(identity, registryId, objSave);
        }

        #endregion

        #region ETL_ExtractBatch_Log

        [WebMethod]
        public List<ETL_ExtractBatch_Log> ETL_ExtractBatch_Log_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.ETL_ExtractBatch_Log_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/ETL_ExtractBatch_Log_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<ETL_ExtractBatch_Log> ETL_ExtractBatch_Log_GET_ALL_BY_REGISTRY_XML(string identity, int registryId)
        {
            return this.ETL_ExtractBatch_Log_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/ETL_ExtractBatch_Log_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<ETL_ExtractBatch_Log> ETL_ExtractBatch_Log_GET_ALL_BY_REGISTRY_JSON(string identity, int registryId)
        {
            return this.ETL_ExtractBatch_Log_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        #endregion

        #region PATIENT

        [WebMethod]
        public PATIENT PATIENT_GET(string identity, int registryId, int id)
        {
            return VIRPManager.PATIENT_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/PATIENT_GET?identity={identity}&registryId={registryId}&id={id}")]
        public PATIENT PATIENT_GET_XML(string identity, int registryId, int id)
        {
            return this.PATIENT_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/PATIENT_GET?identity={identity}&registryId={registryId}&id={id}")]
        public PATIENT PATIENT_GET_JSON(string identity, int registryId, int id)
        {
            return this.PATIENT_GET(identity, registryId, id);
        }

        [WebMethod]
        public PATIENT PATIENT_GET_COMPLETE(string identity, int registryId, int id)
        {
            return VIRPManager.PATIENT_GET_COMPLETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/PATIENT_GET_COMPLETE?identity={identity}&registryId={registryId}&patientId={patientId}")]
        public PATIENT PATIENT_GET_COMPLETE_XML(string identity, int registryId, int patientId)
        {
            return this.PATIENT_GET_COMPLETE(identity, registryId, patientId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/PATIENT_GET_COMPLETE?identity={identity}&registryId={registryId}&patientId={patientId}")]
        public PATIENT PATIENT_GET_COMPLETE_JSON(string identity, int registryId, int patientId)
        {
            return this.PATIENT_GET_COMPLETE(identity, registryId, patientId);
        }

        [WebMethod]
        public List<PATIENT> PATIENT_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.PATIENT_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/PATIENT_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<PATIENT> PATIENT_GET_ALL_BY_REGISTRY_XML(string identity, int registryId)
        {
            return this.PATIENT_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/PATIENT_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<PATIENT> PATIENT_GET_ALL_BY_REGISTRY_JSON(string identity, int registryId)
        {
            return this.PATIENT_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [WebMethod]
        public List<PATIENT> PATIENT_GET_ALL_BY_NAME(string identity, int registryId, string lastName, string firstName)
        {
            return VIRPManager.PATIENT_GET_ALL_BY_NAME(identity, registryId, lastName, firstName);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/PATIENT_GET_ALL_BY_NAME?identity={identity}&registryId={registryId}&lastName={lastName}&firstName={firstName}")]
        public List<PATIENT> PATIENT_GET_ALL_BY_NAME_XML(string identity, int registryId, string lastName, string firstName)
        {
            return this.PATIENT_GET_ALL_BY_NAME(identity, registryId, lastName, firstName);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/PATIENT_GET_ALL_BY_NAME?identity={identity}&registryId={registryId}&lastName={lastName}&firstName={firstName}")]
        public List<PATIENT> PATIENT_GET_ALL_BY_NAME_JSON(string identity, int registryId, string lastName, string firstName)
        {
            return this.PATIENT_GET_ALL_BY_NAME(identity, registryId, lastName, firstName);
        }

        //[WebMethod]
        //public int PATIENT_GET_COMMON_BY_REGISTRY_COUNT(string identity, int registryId, string searchColumn, string searchText)
        //{
        //    return VIRPManager.PATIENT_GET_COMMON_BY_REGISTRY_COUNT(identity, registryId, searchColumn, searchText);
        //}

        //[OperationContract]
        //[WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/PATIENT_GET_COMMON_BY_REGISTRY_COUNT?identity={identity}&registryId={registryId}&searchColumn={searchColumn}&searchText={searchText}")]
        //public int PATIENT_GET_COMMON_BY_REGISTRY_COUNT_XML(string identity, int registryId, string searchColumn, string searchText)
        //{
        //    return this.PATIENT_GET_COMMON_BY_REGISTRY_COUNT(identity, registryId, searchColumn, searchText);
        //}

        //[OperationContract]
        //[WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/PATIENT_GET_COMMON_BY_REGISTRY_COUNT?identity={identity}&registryId={registryId}&searchColumn={searchColumn}&searchText={searchText}")]
        //public int PATIENT_GET_COMMON_BY_REGISTRY_COUNT_JSON(string identity, int registryId, string searchColumn, string searchText)
        //{
        //    return this.PATIENT_GET_COMMON_BY_REGISTRY_COUNT(identity, registryId, searchColumn, searchText);
        //}

        //[WebMethod]
        //public List<REFERRALcommon> PATIENT_GET_COMMON_BY_REGISTRY_FILTER(string identity, int registryId, string searchColumn, string searchText, string sortExpression, int startRow, int maxRows)
        //{
        //    return VIRPManager.PATIENT_GET_COMMON_BY_REGISTRY(identity, registryId, searchColumn, searchText, sortExpression, startRow, maxRows);
        //}

        //[OperationContract]
        //[WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/PATIENT_GET_COMMON_BY_REGISTRY_FILTER?identity={identity}&registryId={registryId}&searchColumn={searchColumn}&searchText={searchText}&sortExpression={sortExpression}&startRow={startRow}&maxRows={maxRows}")]
        //public List<REFERRALcommon> PATIENT_GET_COMMON_BY_REGISTRY_FILTER_XML(string identity, int registryId, string searchColumn, string searchText, string sortExpression, int startRow, int maxRows)
        //{
        //    return this.PATIENT_GET_COMMON_BY_REGISTRY_FILTER(identity, registryId, searchColumn, searchText, sortExpression, startRow, maxRows);
        //}

        //[OperationContract]
        //[WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/PATIENT_GET_COMMON_BY_REGISTRY_FILTER?identity={identity}&registryId={registryId}&searchColumn={searchColumn}&searchText={searchText}&sortExpression={sortExpression}&startRow={startRow}&maxRows={maxRows}")]
        //public List<REFERRALcommon> PATIENT_GET_COMMON_BY_REGISTRY_FILTER_JSON(string identity, int registryId, string searchColumn, string searchText, string sortExpression, int startRow, int maxRows)
        //{
        //    return this.PATIENT_GET_COMMON_BY_REGISTRY_FILTER(identity, registryId, searchColumn, searchText, sortExpression, startRow, maxRows);
        //}

        #endregion

        #region PATIENT_REG

        [WebMethod]
        public PATIENT_REG PATIENT_REG_GET(string identity, int registryId, int id)
        {
            return VIRPManager.PATIENT_REG_GET(identity, registryId, id);
        }

        #endregion

        #region PATIENT_UDFs

        [WebMethod]
        public int PATIENT_UDFs_SAVE(string identity, int registryId, PATIENT_UDFs objSave)
        {
            return VIRPManager.PATIENT_UDFs_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/PATIENT_UDFs_SAVE?identity={identity}&registryId={registryId}")]
        public int PATIENT_UDFs_SAVE_XML(string identity, int registryId, PATIENT_UDFs objSave)
        {
            return this.PATIENT_UDFs_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/PATIENT_UDFs_SAVE?identity={identity}&registryId={registryId}")]
        public int PATIENT_UDFs_SAVE_JSON(string identity, int registryId, PATIENT_UDFs objSave)
        {
            return this.PATIENT_UDFs_SAVE(identity, registryId, objSave);
        }

        [WebMethod]
        public PATIENT_UDFs PATIENT_UDFs_GET_BY_PATIENT_UDF(string identity, int registryId, int patientId, int udfId)
        {
            return VIRPManager.PATIENT_UDFs_GET_BY_PATIENT_UDF(identity, registryId, patientId, udfId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/PATIENT_UDFs_GET_BY_PATIENT_UDF?identity={identity}&registryId={registryId}&patientId={patientId}&udfId={udfId}")]
        public PATIENT_UDFs PATIENT_UDFs_GET_BY_PATIENT_UDF_XML(string identity, int registryId, int patientId, int udfId)
        {
            return this.PATIENT_UDFs_GET_BY_PATIENT_UDF(identity, registryId, patientId, udfId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/PATIENT_UDFs_GET_BY_PATIENT_UDF?identity={identity}&registryId={registryId}&patientId={patientId}&udfId={udfId}")]
        public PATIENT_UDFs PATIENT_UDFs_GET_BY_PATIENT_UDF_JSON(string identity, int registryId, int patientId, int udfId)
        {
            return this.PATIENT_UDFs_GET_BY_PATIENT_UDF(identity, registryId, patientId, udfId);
        }

        #endregion

        #region REFERRAL

        [WebMethod]
        public REFERRAL REFERRAL_GET(string identity, int registryId, int id)
        {
            return VIRPManager.REFERRAL_GET(identity, registryId, id);
        }

        [WebMethod]
        public REFERRAL REFERRAL_GET_BY_PATIENTICN(string identity, int registryId, string patientIcn)
        {
            return VIRPManager.REFERRAL_GET_BY_PATIENTICN(identity, registryId, patientIcn);
        }

        [WebMethod]
        public int REFERRAL_SAVE(string identity, int registryId, REFERRAL objSave)
        {
            return VIRPManager.REFERRAL_SAVE(identity, registryId, objSave);
        }

        [WebMethod]
        public Boolean REFERRAL_DELETE(string identity, int registryId, int id)
        {
            return VIRPManager.REFERRAL_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REFERRAL_GET?identity={identity}&registryId={registryId}&id={id}")]
        public REFERRAL REFERRAL_GET_XML(string identity, int registryId, int id)
        {
            return this.REFERRAL_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REFERRAL_SAVE?identity={identity}&registryId={registryId}")]
        public int REFERRAL_SAVE_XML(string identity, int registryId, REFERRAL objSave)
        {
            return this.REFERRAL_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REFERRAL_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean REFERRAL_DELETE_XML(string identity, int registryId, int id)
        {
            return this.REFERRAL_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REFERRAL_GET?identity={identity}&registryId={registryId}&id={id}")]
        public REFERRAL REFERRAL_GET_JSON(string identity, int registryId, int id)
        {
            return this.REFERRAL_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REFERRAL_SAVE?identity={identity}&registryId={registryId}")]
        public int REFERRAL_SAVE_JSON(string identity, int registryId, REFERRAL objSave)
        {
            return this.REFERRAL_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REFERRAL_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean REFERRAL_DELETE_JSON(string identity, int registryId, int id)
        {
            return this.REFERRAL_DELETE(identity, registryId, id);
        }

        [WebMethod]
        public REFERRAL REFERRAL_GET_COMPLETE(string identity, int registryId, int referralId)
        {
            return VIRPManager.REFERRAL_GET_COMPLETE(identity, registryId, referralId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REFERRAL_GET_COMPLETE?identity={identity}&registryId={registryId}&referralId={referralId}")]
        public REFERRAL REFERRAL_GET_COMPLETE_XML(string identity, int registryId, int referralId)
        {
            return this.REFERRAL_GET_COMPLETE(identity, registryId, referralId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REFERRAL_GET_COMPLETE?identity={identity}&registryId={registryId}&referralId={referralId}")]
        public REFERRAL REFERRAL_GET_COMPLETE_JSON(string identity, int registryId, int referralId)
        {
            return this.REFERRAL_GET_COMPLETE(identity, registryId, referralId);
        }

        [WebMethod]
        public List<REFERRAL> REFERRAL_GET_ALL_BY_REGISTRY_STATUS(string identity, int registryId, int statusId)
        {
            return VIRPManager.REFERRAL_GET_ALL_BY_REGISTRY_STATUS(identity, registryId, statusId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REFERRAL_GET_ALL_BY_REGISTRY_STATUS?identity={identity}&registryId={registryId}&statusId={statusId}")]
        public List<REFERRAL> REFERRAL_GET_ALL_BY_REGISTRY_STATUS_XML(string identity, int registryId, int statusId)
        {
            return this.REFERRAL_GET_ALL_BY_REGISTRY_STATUS(identity, registryId, statusId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REFERRAL_GET_ALL_BY_REGISTRY_STATUS?identity={identity}&registryId={registryId}&statusId={statusId}")]
        public List<REFERRAL> REFERRAL_GET_ALL_BY_REGISTRY_STATUS_JSON(string identity, int registryId, int statusId)
        {
            return this.REFERRAL_GET_ALL_BY_REGISTRY_STATUS(identity, registryId, statusId);
        }

        [WebMethod(BufferResponse = false, CacheDuration = 60)]
        public List<REFERRALcommon> REFERRAL_GET_COMMON_BY_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.REFERRAL_GET_COMMON_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REFERRAL_GET_COMMON_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<REFERRALcommon> REFERRAL_GET_COMMON_BY_REGISTRY_XML(string identity, int registryId)
        {
            return this.REFERRAL_GET_COMMON_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REFERRAL_GET_COMMON_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<REFERRALcommon> REFERRAL_GET_COMMON_BY_REGISTRY_JSON(string identity, int registryId)
        {
            return this.REFERRAL_GET_COMMON_BY_REGISTRY(identity, registryId);
        }

        //[WebMethod]
        //public int REFERRAL_GET_COMMON_BY_REGISTRY_COUNT(string identity, int registryId, string searchColumn, string searchText)
        //{
        //    return VIRPManager.REFERRAL_GET_COMMON_BY_REGISTRY_COUNT(identity, registryId, searchColumn, searchText);
        //}

        //[OperationContract]
        //[WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REFERRAL_GET_COMMON_BY_REGISTRY_COUNT?identity={identity}&registryId={registryId}&searchColumn={searchColumn}&searchText={searchText}")]
        //public int REFERRAL_GET_COMMON_BY_REGISTRY_COUNT_XML(string identity, int registryId, string searchColumn, string searchText)
        //{
        //    return this.REFERRAL_GET_COMMON_BY_REGISTRY_COUNT(identity, registryId, searchColumn, searchText);
        //}

        //[OperationContract]
        //[WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REFERRAL_GET_COMMON_BY_REGISTRY_COUNT?identity={identity}&registryId={registryId}&searchColumn={searchColumn}&searchText={searchText}")]
        //public int REFERRAL_GET_COMMON_BY_REGISTRY_COUNT_JSON(string identity, int registryId, string searchColumn, string searchText)
        //{
        //    return this.REFERRAL_GET_COMMON_BY_REGISTRY_COUNT(identity, registryId, searchColumn, searchText);
        //}

        //[WebMethod]
        //public List<REFERRALcommon> REFERRAL_GET_COMMON_BY_REGISTRY_FILTER(string identity, int registryId, string searchColumn, string searchText, string sortExpression, int startRow, int maxRows)
        //{
        //    return VIRPManager.REFERRAL_GET_COMMON_BY_REGISTRY(identity, registryId, searchColumn, searchText, sortExpression, startRow, maxRows);
        //}

        //[OperationContract]
        //[WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REFERRAL_GET_COMMON_BY_REGISTRY_FILTER?identity={identity}&registryId={registryId}&searchColumn={searchColumn}&searchText={searchText}&sortExpression={sortExpression}&startRow={startRow}&maxRows={maxRows}")]
        //public List<REFERRALcommon> REFERRAL_GET_COMMON_BY_REGISTRY_FILTER_XML(string identity, int registryId, string searchColumn, string searchText, string sortExpression, int startRow, int maxRows)
        //{
        //    return this.REFERRAL_GET_COMMON_BY_REGISTRY_FILTER(identity, registryId, searchColumn, searchText, sortExpression, startRow, maxRows);
        //}

        //[OperationContract]
        //[WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REFERRAL_GET_COMMON_BY_REGISTRY_FILTER?identity={identity}&registryId={registryId}&searchColumn={searchColumn}&searchText={searchText}&sortExpression={sortExpression}&startRow={startRow}&maxRows={maxRows}")]
        //public List<REFERRALcommon> REFERRAL_GET_COMMON_BY_REGISTRY_FILTER_JSON(string identity, int registryId, string searchColumn, string searchText, string sortExpression, int startRow, int maxRows)
        //{
        //    return this.REFERRAL_GET_COMMON_BY_REGISTRY_FILTER(identity, registryId, searchColumn, searchText, sortExpression, startRow, maxRows);
        //}

        [WebMethod]
        public REFERRALcommonGroup REFERRAL_GET_COMMON_BY_REGISTRY_FILTER(string identity, int registryId, int patientId, string searchColumn, string searchText, string sortExpression, int startRow, int maxRows, bool IsPatientList)
        {
            return VIRPManager.REFERRAL_GET_COMMON_BY_REGISTRY(identity, registryId, patientId, searchColumn, searchText, sortExpression, startRow, maxRows, IsPatientList);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REFERRAL_GET_COMMON_BY_REGISTRY_FILTER?identity={identity}&registryId={registryId}&patientId={patientId}&searchColumn={searchColumn}&searchText={searchText}&sortExpression={sortExpression}&startRow={startRow}&maxRows={maxRows}&IsPatientList={IsPatientList}")]
        public REFERRALcommonGroup REFERRAL_GET_COMMON_BY_REGISTRY_FILTER_XML(string identity, int registryId, int patientId, string searchColumn, string searchText, string sortExpression, int startRow, int maxRows, bool IsPatientList)
        {
            return this.REFERRAL_GET_COMMON_BY_REGISTRY_FILTER(identity, registryId, patientId, searchColumn, searchText, sortExpression, startRow, maxRows, IsPatientList);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REFERRAL_GET_COMMON_BY_REGISTRY_FILTER?identity={identity}&registryId={registryId}&patientId={patientId}&searchColumn={searchColumn}&searchText={searchText}&sortExpression={sortExpression}&startRow={startRow}&maxRows={maxRows}&IsPatientList={IsPatientList}")]
        public REFERRALcommonGroup REFERRAL_GET_COMMON_BY_REGISTRY_FILTER_JSON(string identity, int registryId, int patientId, string searchColumn, string searchText, string sortExpression, int startRow, int maxRows, bool IsPatientList)
        {
            return this.REFERRAL_GET_COMMON_BY_REGISTRY_FILTER(identity, registryId, patientId, searchColumn, searchText, sortExpression, startRow, maxRows, IsPatientList);
        }

        [WebMethod]
        public List<REFERRALcommon> REFERRAL_GET_COMMON_BY_PATIENT(string identity, int registryId, int patientId)
        {
            return VIRPManager.REFERRAL_GET_COMMON_BY_PATIENT(identity, registryId, patientId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REFERRAL_GET_COMMON_BY_PATIENT?identity={identity}&registryId={registryId}&patientId={patientId}")]
        public List<REFERRALcommon> REFERRAL_GET_COMMON_BY_PATIENT_XML(string identity, int registryId, int patientId)
        {
            return this.REFERRAL_GET_COMMON_BY_PATIENT(identity, registryId, patientId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REFERRAL_GET_COMMON_BY_PATIENT?identity={identity}&registryId={registryId}&patientId={patientId}")]
        public List<REFERRALcommon> REFERRAL_GET_COMMON_BY_PATIENT_JSON(string identity, int registryId, int patientId)
        {
            return this.REFERRAL_GET_COMMON_BY_PATIENT(identity, registryId, patientId);
        }

        [WebMethod]
        public List<REFERRALcommon> REFERRAL_GET_COMMON_BY_PROVIDER(string identity, int registryId, int providerId)
        {
            return VIRPManager.REFERRAL_GET_COMMON_BY_PROVIDER(identity, registryId, providerId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REFERRAL_GET_COMMON_BY_PROVIDER?identity={identity}&registryId={registryId}&providerId={providerId}")]
        public List<REFERRALcommon> REFERRAL_GET_COMMON_BY_PROVIDER_XML(string identity, int registryId, int providerId)
        {
            return this.REFERRAL_GET_COMMON_BY_PROVIDER(identity, registryId, providerId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REFERRAL_GET_COMMON_BY_PROVIDER?identity={identity}&registryId={registryId}&providerId={providerId}")]
        public List<REFERRALcommon> REFERRAL_GET_COMMON_BY_PROVIDER_JSON(string identity, int registryId, int providerId)
        {
            return this.REFERRAL_GET_COMMON_BY_PROVIDER(identity, registryId, providerId);
        }

        [WebMethod]
        public bool REFERRAL_PATIENT_EXISTS(string identity, int registryId, int patientId)
        {
            return VIRPManager.REFERRAL_PATIENT_EXISTS(identity, registryId, patientId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REFERRAL_PATIENT_EXISTS?identity={identity}&registryId={registryId}&patientId={patientId}")]
        public bool REFERRAL_PATIENT_EXISTS_XML(string identity, int registryId, int patientId)
        {
            return this.REFERRAL_PATIENT_EXISTS(identity, registryId, patientId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REFERRAL_PATIENT_EXISTS?identity={identity}&registryId={registryId}&patientId={patientId}")]
        public bool REFERRAL_PATIENT_EXISTS_JSON(string identity, int registryId, int patientId)
        {
            return this.REFERRAL_PATIENT_EXISTS(identity, registryId, patientId);
        }

        [WebMethod]
        public int REFERRAL_SAVE_MANUAL(string identity, int registryId, int patientId, int providerId)
        {
            return VIRPManager.REFERRAL_SAVE_MANUAL(identity, registryId, patientId, providerId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REFERRAL_SAVE_MANUAL?identity={identity}&registryId={registryId}&patientId={patientId}&providerId={providerId}")]
        public int REFERRAL_SAVE_MANUAL_XML(string identity, int registryId, int patientId, int providerId)
        {
            return this.REFERRAL_SAVE_MANUAL(identity, registryId, patientId, providerId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REFERRAL_SAVE_MANUAL?identity={identity}&registryId={registryId}&patientId={patientId}&providerId={providerId}")]
        public int REFERRAL_SAVE_MANUAL_JSON(string identity, int registryId, int patientId, int providerId)
        {
            return this.REFERRAL_SAVE_MANUAL(identity, registryId, patientId, providerId);
        }

        [WebMethod]
        public bool REFERRAL_UPDATE_STATUS(string identity, int registryId, int referralId, int statusId)
        {
            return VIRPManager.REFERRAL_UPDATE_STATUS(identity, registryId, referralId, statusId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REFERRAL_UPDATE_STATUS?identity={identity}&registryId={registryId}&referralId={referralId}&statusId={statusId}")]
        public bool REFERRAL_UPDATE_STATUS_XML(string identity, int registryId, int referralId, int statusId)
        {
            return this.REFERRAL_UPDATE_STATUS(identity, registryId, referralId, statusId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REFERRAL_UPDATE_STATUS?identity={identity}&registryId={registryId}&referralId={referralId}&statusId={statusId}")]
        public bool REFERRAL_STATUS_JSON(string identity, int registryId, int referralId, int statusId)
        {
            return this.REFERRAL_UPDATE_STATUS(identity, registryId, referralId, statusId);
        }

        #endregion

        #region REGISTRY_COHORT_DATA

        [WebMethod]
        public List<REGISTRY_COHORT_DATA> REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<REGISTRY_COHORT_DATA> REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY_XML(string identity, int registryId)
        {
            return this.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<REGISTRY_COHORT_DATA> REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY_JSON(string identity, int registryId)
        {
            return this.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [WebMethod]
        public List<REGISTRY_COHORT_DATA> REGISTRY_COHORT_DATA_GET_ALL_SELECTED_BY_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.REGISTRY_COHORT_DATA_GET_ALL_SELECTED_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REGISTRY_COHORT_DATA_GET_ALL_SELECTED_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<REGISTRY_COHORT_DATA> REGISTRY_COHORT_DATA_GET_ALL_SELECTED_BY_REGISTRY_XML(string identity, int registryId)
        {
            return this.REGISTRY_COHORT_DATA_GET_ALL_SELECTED_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REGISTRY_COHORT_DATA_GET_ALL_SELECTED_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<REGISTRY_COHORT_DATA> REGISTRY_COHORT_DATA_GET_ALL_SELECTED_BY_REGISTRY_JSON(string identity, int registryId)
        {
            return this.REGISTRY_COHORT_DATA_GET_ALL_SELECTED_BY_REGISTRY(identity, registryId);
        }

        [WebMethod]
        public bool REGISTRY_COHORT_DATA_SAVE_LIST(string identity, int registryId, List<REGISTRY_COHORT_DATA> cohorts)
        {
            return VIRPManager.REGISTRY_COHORT_DATA_SAVE_LIST(identity, registryId, cohorts);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REGISTRY_COHORT_DATA_SAVE_LIST?identity={identity}&registryId={registryId}&cohorts={cohorts}")]
        public bool REGISTRY_COHORT_DATA_SAVE_LIST_XML(string identity, int registryId, List<REGISTRY_COHORT_DATA> cohorts)
        {
            return this.REGISTRY_COHORT_DATA_SAVE_LIST(identity, registryId, cohorts);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REGISTRY_COHORT_DATA_SAVE_LIST?identity={identity}&registryId={registryId}&cohorts={cohorts}")]
        public bool REGISTRY_COHORT_DATA_SAVE_LIST_JSON(string identity, int registryId, List<REGISTRY_COHORT_DATA> cohorts)
        {
            return this.REGISTRY_COHORT_DATA_SAVE_LIST(identity, registryId, cohorts);
        }

        [WebMethod]
        public int REGISTRY_COHORT_DATA_GET_PREVIEW_COUNT(string identity, int registryId, List<REGISTRY_COHORT_DATA> cohorts)
        {
            return VIRPManager.REGISTRY_COHORT_DATA_GET_PREVIEW_COUNT(identity, registryId, cohorts);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REGISTRY_COHORT_DATA_GET_PREVIEW_COUNT?identity={identity}&registryId={registryId}&cohorts={cohorts}")]
        public int REGISTRY_COHORT_DATA_GET_PREVIEW_COUNT_JSON(string identity, int registryId, List<REGISTRY_COHORT_DATA> cohorts)
        {
            return this.REGISTRY_COHORT_DATA_GET_PREVIEW_COUNT(identity, registryId, cohorts);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REGISTRY_COHORT_DATA_GET_PREVIEW_COUNT?identity={identity}&registryId={registryId}&cohorts={cohorts}")]
        public int REGISTRY_COHORT_DATA_GET_PREVIEW_COUNT_XML(string identity, int registryId, List<REGISTRY_COHORT_DATA> cohorts)
        {
            return this.REGISTRY_COHORT_DATA_GET_PREVIEW_COUNT(identity, registryId, cohorts);
        }

        #endregion

        #region REGISTRY_CORE_DATA

        [WebMethod]
        public REGISTRY_CORE_DATA REGISTRY_CORE_DATA_GET_BY_REGISTRY_CORE(string identity, int registryId, int CORE_TYPE_ID)
        {
            return VIRPManager.REGISTRY_CORE_DATA_GET_BY_REGISTRY_CORE(identity, registryId, CORE_TYPE_ID);
        }

        [WebMethod]
        public List<REGISTRY_CORE_DATA> REGISTRY_CORE_DATA_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.REGISTRY_CORE_DATA_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [WebMethod]
        public bool REGISTRY_CORE_DATA_SAVE_LIST(string identity, int registryId, List<REGISTRY_CORE_DATA> cores)
        {
            return VIRPManager.REGISTRY_CORE_DATA_SAVE_LIST(identity, registryId, cores);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REGISTRY_CORE_DATA_GET_BY_REGISTRY_CORE?identity={identity}&registryId={registryId}&coreTypeId={coreTypeId}")]
        public REGISTRY_CORE_DATA REGISTRY_CORE_DATA_GET_BY_REGISTRY_CORE_XML(string identity, int registryId, int coreTypeId)
        {
            return this.REGISTRY_CORE_DATA_GET_BY_REGISTRY_CORE(identity, registryId, coreTypeId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REGISTRY_CORE_DATA_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<REGISTRY_CORE_DATA> REGISTRY_CORE_DATA_GET_ALL_BY_REGISTRY_XML(string identity, int registryId)
        {
            return this.REGISTRY_CORE_DATA_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REGISTRY_CORE_DATA_SAVE_LIST?identity={identity}&registryId={registryId}&cores={cores}")]
        public bool REGISTRY_CORE_DATA_SAVE_LIST_XML(string identity, int registryId, List<REGISTRY_CORE_DATA> cores)
        {
            return this.REGISTRY_CORE_DATA_SAVE_LIST(identity, registryId, cores);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REGISTRY_CORE_DATA_GET_BY_REGISTRY_CORE?identity={identity}&registryId={registryId}&coreTypeId={coreTypeId}")]
        public REGISTRY_CORE_DATA REGISTRY_CORE_DATA_GET_BY_REGISTRY_CORE_JSON(string identity, int registryId, int coreTypeId)
        {
            return this.REGISTRY_CORE_DATA_GET_BY_REGISTRY_CORE(identity, registryId, coreTypeId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REGISTRY_CORE_DATA_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<REGISTRY_CORE_DATA> REGISTRY_CORE_DATA_GET_ALL_BY_REGISTRY_JSON(string identity, int registryId)
        {
            return this.REGISTRY_CORE_DATA_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REGISTRY_CORE_DATA_SAVE_LIST?identity={identity}&registryId={registryId}&cores={cores}")]
        public bool REGISTRY_CORE_DATA_SAVE_LIST_JSON(string identity, int registryId, List<REGISTRY_CORE_DATA> cores)
        {
            return this.REGISTRY_CORE_DATA_SAVE_LIST(identity, registryId, cores);
        }

        #endregion

        #region SETTINGS

        [WebMethod]
        public int SETTINGS_SAVE(string identity, int registryId, SETTINGS objSave)
        {
            return VIRPManager.SETTINGS_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/SETTINGS_SAVE?identity={identity}&registryId={registryId}")]
        public int SETTINGS_SAVE_XML(string identity, int registryId, SETTINGS objSave)
        {
            return this.SETTINGS_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/SETTINGS_SAVE?identity={identity}&registryId={registryId}")]
        public int SETTINGS_SAVE_JSON(string identity, int registryId, SETTINGS objSave)
        {
            return this.SETTINGS_SAVE(identity, registryId, objSave);
        }

        [WebMethod]
        public SETTINGS SETTINGS_GET_REGISTRYNAME(string identity, int registryId, string registryName)
        {
            return VIRPManager.SETTINGS_GET_REGISTRYNAME(identity, registryId, registryName);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/SETTINGS_GET_REGISTRYNAME?identity={identity}&registryId={registryId}&registryName={registryName}")]
        public SETTINGS SETTINGS_GET_REGISTRYNAME_XML(string identity, int registryId, string registryName)
        {
            return this.SETTINGS_GET_REGISTRYNAME(identity, registryId, registryName);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/SETTINGS_GET_REGISTRYNAME?identity={identity}&registryId={registryId}&registryName={registryName}")]
        public SETTINGS SETTINGS_GET_REGISTRYNAME_JSON(string identity, int registryId, string registryName)
        {
            return this.SETTINGS_GET_REGISTRYNAME(identity, registryId, registryName);
        }

        [WebMethod]
        public SETTINGS SETTINGS_GET_HOME_PAGE()
        {
            return VIRPManager.SETTINGS_GET_HOME_PAGE();
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/GET_HOME_PAGE_SETTING")]
        public SETTINGS SETTINGS_GET_HOME_PAGE_XML()
        {
            return this.SETTINGS_GET_HOME_PAGE();
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/GET_HOME_PAGE_SETTING")]
        public SETTINGS SETTINGS_GET_HOME_PAGE_JSON()
        {
            return this.SETTINGS_GET_HOME_PAGE();
        }

        [WebMethod]
        public List<SETTINGS> SETTINGS_GET()
        {
            return VIRPManager.SETTINGS_GET();
        }

        #endregion

        #region SStaff_SStaff

        [WebMethod]
        public SStaff_SStaff SStaff_SStaff_GET(string identity, int registryId, int id)
        {
            return VIRPManager.SStaff_SStaff_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/SStaff_SStaff_GET?identity={identity}&registryId={registryId}&id={id}")]
        public SStaff_SStaff SStaff_SStaff_GET_XML(string identity, int registryId, int id)
        {
            return this.SStaff_SStaff_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/SStaff_SStaff_GET?identity={identity}&registryId={registryId}&id={id}")]
        public SStaff_SStaff SStaff_SStaff_GET_JSON(string identity, int registryId, int id)
        {
            return this.SStaff_SStaff_GET(identity, registryId, id);
        }

        //[WebMethod()]
        //public int SStaff_SStaff_GET_ALL_BY_REGISTRY_COUNT(string identity, int registryId, string searchColumn, string searchText)
        //{
        //    return VIRPManager.SStaff_SStaff_GET_ALL_BY_REGISTRY_COUNT(identity, registryId, searchColumn, searchText);
        //}

        //[OperationContract]
        //[WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/SStaff_SStaff_GET_ALL_BY_REGISTRY_COUNT?identity={identity}&registryId={registryId}&searchColumn={searchColumn}&searchText={searchText}")]
        //public int SStaff_SStaff_GET_ALL_BY_REGISTRY_COUNT_XML(string identity, int registryId, string searchColumn, string searchText)
        //{
        //    return this.SStaff_SStaff_GET_ALL_BY_REGISTRY_COUNT(identity, registryId, searchColumn, searchText);
        //}

        //[OperationContract]
        //[WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/SStaff_SStaff_GET_ALL_BY_REGISTRY_COUNT?identity={identity}&registryId={registryId}&searchColumn={searchColumn}&searchText={searchText}")]
        //public int SStaff_SStaff_GET_ALL_BY_REGISTRY_COUNT_JSON(string identity, int registryId, string searchColumn, string searchText)
        //{
        //    return this.SStaff_SStaff_GET_ALL_BY_REGISTRY_COUNT(identity, registryId, searchColumn, searchText);
        //}

        [WebMethod]
        public List<SStaff_SStaff> SStaff_SStaff_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.SStaff_SStaff_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/SStaff_SStaff_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<SStaff_SStaff> SStaff_SStaff_GET_ALL_BY_REGISTRY_XML(string identity, int registryId)
        {
            return this.SStaff_SStaff_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/SStaff_SStaff_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<SStaff_SStaff> SStaff_SStaff_GET_ALL_BY_REGISTRY_JSON(string identity, int registryId)
        {
            return this.SStaff_SStaff_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [WebMethod]
        public List<SStaff_SStaff> SStaff_SStaff_GET_ALL_BY_REGISTRY_FILTER(string identity, int registryId, string searchColumn, string searchText, string sortExpression, int startRow, int maxRows)
        {
            return VIRPManager.SStaff_SStaff_GET_ALL_BY_REGISTRY(identity, registryId, searchColumn, searchText, sortExpression, startRow, maxRows);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/SStaff_SStaff_GET_ALL_BY_REGISTRY_FILTER?identity={identity}&registryId={registryId}&searchColumn={searchColumn}&searchText={searchText}&sortExpression={sortExpression}&startRow={startRow}&maxRows={maxRows}")]
        public List<SStaff_SStaff> SStaff_SStaff_GET_ALL_BY_REGISTRY_FILTER_XML(string identity, int registryId, string searchColumn, string searchText, string sortExpression, int startRow, int maxRows)
        {
            return this.SStaff_SStaff_GET_ALL_BY_REGISTRY_FILTER(identity, registryId, searchColumn, searchText, sortExpression, startRow, maxRows);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/SStaff_SStaff_GET_ALL_BY_REGISTRY_FILTER?identity={identity}&registryId={registryId}&searchColumn={searchColumn}&searchText={searchText}&sortExpression={sortExpression}&startRow={startRow}&maxRows={maxRows}")]
        public List<SStaff_SStaff> SStaff_SStaff_GET_ALL_BY_REGISTRY_FILTER_JSON(string identity, int registryId, string searchColumn, string searchText, string sortExpression, int startRow, int maxRows)
        {
            return this.SStaff_SStaff_GET_ALL_BY_REGISTRY_FILTER(identity, registryId, searchColumn, searchText, sortExpression, startRow, maxRows);
        }

        [WebMethod]
        public int SStaff_SStaff_GET_ALL_BY_REGISTRY_FILTER_COUNT(string identity, int registryId, string searchColumn, string searchText, string sortExpression)
        {
            return VIRPManager.SStaff_SStaff_GET_ALL_BY_REGISTRY_COUNT(identity, registryId, searchColumn, searchText, sortExpression);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/SStaff_SStaff_GET_ALL_BY_REGISTRY_FILTER_COUNT?identity={identity}&registryId={registryId}&searchColumn={searchColumn}&searchText={searchText}&sortExpression={sortExpression}")]
        public int SStaff_SStaff_GET_ALL_BY_REGISTRY_FILTER_COUNT_XML(string identity, int registryId, string searchColumn, string searchText, string sortExpression)
        {
            return this.SStaff_SStaff_GET_ALL_BY_REGISTRY_FILTER_COUNT(identity, registryId, searchColumn, searchText, sortExpression);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/SStaff_SStaff_GET_ALL_BY_REGISTRY_FILTER_COUNT?identity={identity}&registryId={registryId}&searchColumn={searchColumn}&searchText={searchText}&sortExpression={sortExpression}")]
        public int SStaff_SStaff_GET_ALL_BY_REGISTRY_FILTER_COUNT_JSON(string identity, int registryId, string searchColumn, string searchText, string sortExpression)
        {
            return this.SStaff_SStaff_GET_ALL_BY_REGISTRY_FILTER_COUNT(identity, registryId, searchColumn, searchText, sortExpression);
        }

        [WebMethod]
        public List<SStaff_SStaff> SStaff_SStaff_GET_ALL_BY_NAME(string identity, int registryId, string lastName, string firstName)
        {
            return VIRPManager.SStaff_SStaff_GET_ALL_BY_NAME(identity, registryId, lastName, firstName);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/SStaff_SStaff_GET_ALL_BY_NAME?identity={identity}&registryId={registryId}&lastName={lastName}&firstName={firstName}")]
        public List<SStaff_SStaff> SStaff_SStaff_GET_ALL_BY_NAME_XML(string identity, int registryId, string lastName, string firstName)
        {
            return this.SStaff_SStaff_GET_ALL_BY_NAME(identity, registryId, lastName, firstName);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/SStaff_SStaff_GET_ALL_BY_NAME?identity={identity}&registryId={registryId}&lastName={lastName}&firstName={firstName}")]
        public List<SStaff_SStaff> SStaff_SStaff_GET_ALL_BY_NAME_JSON(string identity, int registryId, string lastName, string firstName)
        {
            return this.SStaff_SStaff_GET_ALL_BY_NAME(identity, registryId, lastName, firstName);
        }

        #endregion

        #region STD_GENDER

        [WebMethod]
        public STD_GENDER STD_GENDER_GET(string identity, int registryId, int id)
        {
            return VIRPManager.STD_GENDER_GET(identity, registryId, id);
        }

        [WebMethod]
        public List<STD_GENDER> STD_GENDER_GET_ALL(string identity, int registryId)
        {
            return VIRPManager.STD_GENDER_GET_ALL(identity, registryId);
        }

        [WebMethod]
        public int STD_GENDER_SAVE(string identity, int registryId, STD_GENDER objSave)
        {
            return VIRPManager.STD_GENDER_SAVE(identity, registryId, objSave);
        }

        [WebMethod]
        public Boolean STD_GENDER_DELETE(string identity, int registryId, int id)
        {
            return VIRPManager.STD_GENDER_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_GENDER_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_GENDER STD_GENDER_GET_XML(string identity, int registryId, int id)
        {
            return this.STD_GENDER_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_GENDER_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_GENDER_SAVE_XML(string identity, int registryId, STD_GENDER objSave)
        {
            return this.STD_GENDER_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_GENDER_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_GENDER_DELETE_XML(string identity, int registryId, int id)
        {
            return this.STD_GENDER_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_GENDER_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_GENDER STD_GENDER_GET_JSON(string identity, int registryId, int id)
        {
            return this.STD_GENDER_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_GENDER_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_GENDER_SAVE_JSON(string identity, int registryId, STD_GENDER objSave)
        {
            return this.STD_GENDER_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_GENDER_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_GENDER_DELETE_JSON(string identity, int registryId, int id)
        {
            return this.STD_GENDER_DELETE(identity, registryId, id);
        }

        #endregion

        #region STD_INSTITUTION

        [WebMethod]
        public STD_INSTITUTION STD_INSTITUTION_GET_COMPLETE(string identity, int registryId, int id)
        {
            return VIRPManager.STD_INSTITUTION_GET_COMPLETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_INSTITUTION_GET_COMPLETE?identity={identity}&registryId={registryId}&id={id}")]
        public STD_INSTITUTION STD_INSTITUTION_GET_COMPLETE_XML(string identity, int registryId, int id)
        {
            return this.STD_INSTITUTION_GET_COMPLETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_INSTITUTION_GET_COMPLETE?identity={identity}&registryId={registryId}&id={id}")]
        public STD_INSTITUTION STD_INSTITUTION_GET_COMPLETE_JSON(string identity, int registryId, int id)
        {
            return this.STD_INSTITUTION_GET_COMPLETE(identity, registryId, id);
        }

        [WebMethod]
        public List<STD_INSTITUTION> STD_INSTITUTION_GET_FACS(string identity, int registryId)
        {
            return VIRPManager.STD_INSTITUTION_GET_FACS(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_INSTITUTION_GET_FACS?identity={identity}&registryId={registryId}")]
        public List<STD_INSTITUTION> STD_INSTITUTION_GET_FACS_XML(string identity, int registryId)
        {
            return this.STD_INSTITUTION_GET_FACS(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_INSTITUTION_GET_FACS?identity={identity}&registryId={registryId}")]
        public List<STD_INSTITUTION> STD_INSTITUTION_GET_FACS_JSON(string identity, int registryId)
        {
            return this.STD_INSTITUTION_GET_FACS(identity, registryId);
        }

        [WebMethod]
        public List<STD_INSTITUTION> STD_INSTITUTION_GET_VISNS(string identity, int registryId)
        {
            return VIRPManager.STD_INSTITUTION_GET_VISNS(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_INSTITUTION_GET_VISNS?identity={identity}&registryId={registryId}")]
        public List<STD_INSTITUTION> STD_INSTITUTION_GET_VISNS_XML(string identity, int registryId)
        {
            return this.STD_INSTITUTION_GET_VISNS(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_INSTITUTION_GET_VISNS?identity={identity}&registryId={registryId}")]
        public List<STD_INSTITUTION> STD_INSTITUTION_GET_VISNS_JSON(string identity, int registryId)
        {
            return this.STD_INSTITUTION_GET_VISNS(identity, registryId);
        }

        [WebMethod]
        public List<STD_INSTITUTION> STD_INSTITUTION_GET_ALL(string identity, int registryId)
        {
            return VIRPManager.STD_INSTITUTION_GET_ALL(identity, registryId);
        }

        [WebMethod]
        public List<STD_INSTITUTION> STD_INSTITUTION_GET_FACILITIES(string identity, int registryId)
        {
            return VIRPManager.STD_INSTITUTION_GET_FACILITIES(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_INSTITUTION_GET_FACILITIES?identity={identity}&registryId={registryId}")]
        public List<STD_INSTITUTION> STD_INSTITUTION_GET_FACILITIES_XML(string identity, int registryId)
        {
            return this.STD_INSTITUTION_GET_FACILITIES(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_INSTITUTION_GET_FACILITIES?identity={identity}&registryId={registryId}")]
        public List<STD_INSTITUTION> STD_INSTITUTION_GET_FACILITIES_JSON(string identity, int registryId)
        {
            return this.STD_INSTITUTION_GET_FACILITIES(identity, registryId);
        }

        [WebMethod]
        public bool STD_INSTITUTION_SAVE_VISNS(string identity, int registryId, int userId, List<int> visnIds)
        {
            return VIRPManager.STD_INSTITUTION_SAVE_VISNS(identity, registryId, userId, visnIds);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_INSTITUTION_SAVE_VISNS?identity={identity}&registryId={registryId}&userId={userId}&visnIds={visnIds}")]
        public bool STD_INSTITUTION_SAVE_VISNS_XML(string identity, int registryId, int userId, List<int> visnIds)
        {
            return this.STD_INSTITUTION_SAVE_VISNS(identity, registryId, userId, visnIds);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_INSTITUTION_SAVE_VISNS?identity={identity}&registryId={registryId}&userId={userId}&visnIds={visnIds}")]
        public bool STD_INSTITUTION_SAVE_VISNS_JSON(string identity, int registryId, int userId, List<int> visnIds)
        {
            return this.STD_INSTITUTION_SAVE_VISNS(identity, registryId, userId, visnIds);
        }

        [WebMethod]
        public bool STD_INSTITUTION_SAVE_FACILITIES(string identity, int registryId, int userId, List<int> facIds)
        {
            return VIRPManager.STD_INSTITUTION_SAVE_FACILITIES(identity, registryId, userId, facIds);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_INSTITUTION_SAVE_FACILITIES?identity={identity}&registryId={registryId}&userId={userId}&facIds={facIds}")]
        public bool STD_INSTITUTION_SAVE_FACILITIES_XML(string identity, int registryId, int userId, List<int> facIds)
        {
            return this.STD_INSTITUTION_SAVE_FACILITIES(identity, registryId, userId, facIds);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_INSTITUTION_SAVE_FACILITIES?identity={identity}&registryId={registryId}&userId={userId}&facIds={facIds}")]
        public bool STD_INSTITUTION_SAVE_FACILITIES_JSON(string identity, int registryId, int userId, List<int> facIds)
        {
            return this.STD_INSTITUTION_SAVE_FACILITIES(identity, registryId, userId, facIds);
        }

        [WebMethod]
        public List<STD_INSTITUTION> USER_SITES_GET_ALL_VISNS_BY_USER(string identity, int registryId, int userId)
        {
            return VIRPManager.USER_SITES_GET_ALL_VISNS_BY_USER(identity, registryId, userId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/USER_SITES_GET_ALL_VISNS_BY_USER?identity={identity}&registryId={registryId}&userId={userId}")]
        public List<STD_INSTITUTION> USER_SITES_GET_ALL_VISNS_BY_USER_XML(string identity, int registryId, int userId)
        {
            return this.USER_SITES_GET_ALL_VISNS_BY_USER(identity, registryId, userId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/USER_SITES_GET_ALL_VISNS_BY_USER?identity={identity}&registryId={registryId}&userId={userId}")]
        public List<STD_INSTITUTION> USER_SITES_GET_ALL_VISNS_BY_USER_JSON(string identity, int registryId, int userId)
        {
            return this.USER_SITES_GET_ALL_VISNS_BY_USER(identity, registryId, userId);
        }

        [WebMethod]
        public List<STD_INSTITUTION> USER_SITES_GET_ALL_FACILITIES_BY_USER(string identity, int registryId, int userId)
        {
            return VIRPManager.USER_SITES_GET_ALL_FACILITIES_BY_USER(identity, registryId, userId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/USER_SITES_GET_ALL_FACILITIES_BY_USER?identity={identity}&registryId={registryId}&userId={userId}")]
        public List<STD_INSTITUTION> USER_SITES_GET_ALL_FACILITIES_BY_USER_XML(string identity, int registryId, int userId)
        {
            return this.USER_SITES_GET_ALL_FACILITIES_BY_USER(identity, registryId, userId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/USER_SITES_GET_ALL_FACILITIES_BY_USER?identity={identity}&registryId={registryId}&userId={userId}")]
        public List<STD_INSTITUTION> USER_SITES_GET_ALL_FACILITIES_BY_USER_JSON(string identity, int registryId, int userId)
        {
            return this.USER_SITES_GET_ALL_FACILITIES_BY_USER(identity, registryId, userId);
        }

        #endregion

        #region STD_MENU_ITEMS

        [WebMethod]
        public STD_MENU_ITEMS STD_MENU_ITEMS_GET(string identity, int registryId, int id)
        {
            return VIRPManager.STD_MENU_ITEMS_GET(identity, registryId, id);
        }

        [WebMethod]
        public int STD_MENU_ITEMS_SAVE(string identity, int registryId, STD_MENU_ITEMS objSave)
        {
            return VIRPManager.STD_MENU_ITEMS_SAVE(identity, registryId, objSave);
        }

        [WebMethod]
        public Boolean STD_MENU_ITEMS_DELETE(string identity, int registryId, int id)
        {
            return VIRPManager.STD_MENU_ITEMS_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_MENU_ITEMS_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_MENU_ITEMS STD_MENU_ITEMS_GET_XML(string identity, int registryId, int id)
        {
            return this.STD_MENU_ITEMS_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_MENU_ITEMS_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_MENU_ITEMS_SAVE_XML(string identity, int registryId, STD_MENU_ITEMS objSave)
        {
            return this.STD_MENU_ITEMS_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_MENU_ITEMS_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_MENU_ITEMS_DELETE_XML(string identity, int registryId, int id)
        {
            return this.STD_MENU_ITEMS_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_MENU_ITEMS_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_MENU_ITEMS STD_MENU_ITEMS_GET_JSON(string identity, int registryId, int id)
        {
            return this.STD_MENU_ITEMS_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_MENU_ITEMS_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_MENU_ITEMS_SAVE_JSON(string identity, int registryId, STD_MENU_ITEMS objSave)
        {
            return this.STD_MENU_ITEMS_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_MENU_ITEMS_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_MENU_ITEMS_DELETE_JSON(string identity, int registryId, int id)
        {
            return this.STD_MENU_ITEMS_DELETE(identity, registryId, id);
        }

        [WebMethod]
        public List<STD_MENU_ITEMS> STD_MENU_ITEMS_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.STD_MENU_ITEMS_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_MENU_ITEMS_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<STD_MENU_ITEMS> STD_MENU_ITEMS_GET_ALL_BY_REGISTRY_XML(string identity, int registryId)
        {
            return this.STD_MENU_ITEMS_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_MENU_ITEMS_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<STD_MENU_ITEMS> STD_MENU_ITEMS_GET_ALL_BY_REGISTRY_JSON(string identity, int registryId)
        {
            return this.STD_MENU_ITEMS_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [WebMethod]
        public List<STD_MENU_ITEMS> STD_MENU_ITEMS_GET_MENU(string identity, int registryId, string path)
        {
            return VIRPManager.STD_MENU_ITEMS_GET_MENU(identity, registryId, path);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_MENU_ITEMS_GET_MENU?identity={identity}&registryId={registryId}&path={path}")]
        public List<STD_MENU_ITEMS> STD_MENU_ITEMS_GET_MENU_XML(string identity, int registryId, string path)
        {
            return this.STD_MENU_ITEMS_GET_MENU(identity, registryId, path);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_MENU_ITEMS_GET_MENU?identity={identity}&registryId={registryId}&path={path}")]
        public List<STD_MENU_ITEMS> STD_MENU_ITEMS_GET_MENU_JSON(string identity, int registryId, string path)
        {
            return this.STD_MENU_ITEMS_GET_MENU(identity, registryId, path);
        }

        #endregion

        #region STD_QUESTION

        [WebMethod]
        public STD_QUESTION STD_QUESTION_GET(string identity, int registryId, int id)
        {
            return VIRPManager.STD_QUESTION_GET(identity, registryId, id);
        }

        [WebMethod]
        public int STD_QUESTION_SAVE(string identity, int registryId, STD_QUESTION objSave)
        {
            return VIRPManager.STD_QUESTION_SAVE(identity, registryId, objSave);
        }

        [WebMethod]
        public Boolean STD_QUESTION_DELETE(string identity, int registryId, int id)
        {
            return VIRPManager.STD_QUESTION_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_QUESTION_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_QUESTION STD_QUESTION_GET_XML(string identity, int registryId, int id)
        {
            return this.STD_QUESTION_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_QUESTION_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_QUESTION_SAVE_XML(string identity, int registryId, STD_QUESTION objSave)
        {
            return this.STD_QUESTION_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_QUESTION_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_QUESTION_DELETE_XML(string identity, int registryId, int id)
        {
            return this.STD_QUESTION_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_QUESTION_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_QUESTION STD_QUESTION_GET_JSON(string identity, int registryId, int id)
        {
            return this.STD_QUESTION_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_QUESTION_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_QUESTION_SAVE_JSON(string identity, int registryId, STD_QUESTION objSave)
        {
            return this.STD_QUESTION_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_QUESTION_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_QUESTION_DELETE_JSON(string identity, int registryId, int id)
        {
            return this.STD_QUESTION_DELETE(identity, registryId, id);
        }

        [WebMethod]
        public List<STD_QUESTION> STD_QUESTION_GET_ALL_BY_SURVEY(string identity, int registryId, int surveyTypeId)
        {
            return VIRPManager.STD_QUESTION_GET_ALL_BY_SURVEY(identity, registryId, surveyTypeId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_QUESTION_GET_ALL_BY_SURVEY?identity={identity}&registryId={registryId}&surveyTypeId={surveyTypeId}")]
        public List<STD_QUESTION> STD_QUESTION_GET_ALL_BY_SURVEY_XML(string identity, int registryId, int surveyTypeId)
        {
            return this.STD_QUESTION_GET_ALL_BY_SURVEY(identity, registryId, surveyTypeId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_QUESTION_GET_ALL_BY_SURVEY?identity={identity}&registryId={registryId}&surveyTypeId={surveyTypeId}")]
        public List<STD_QUESTION> STD_QUESTION_GET_ALL_BY_SURVEY_JSON(string identity, int registryId, int surveyTypeId)
        {
            return this.STD_QUESTION_GET_ALL_BY_SURVEY(identity, registryId, surveyTypeId);
        }

        [WebMethod]
        public Boolean STD_QUESTION_COPY_CHOICES(string identity, int registryId, int oldQuestionId, int newQuestionId)
        {
            return VIRPManager.STD_QUESTION_COPY_CHOICES(identity, registryId, oldQuestionId, newQuestionId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_QUESTION_COPY_CHOICES?identity={identity}&registryId={registryId}&oldQuestionId={oldQuestionId}&newQuestionId={newQuestionId}")]
        public Boolean STD_QUESTION_COPY_CHOICES_XML(string identity, int registryId, int oldQuestionId, int newQuestionId)
        {
            return this.STD_QUESTION_COPY_CHOICES(identity, registryId, oldQuestionId, newQuestionId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_QUESTION_COPY_CHOICES?identity={identity}&registryId={registryId}&oldQuestionId={oldQuestionId}&newQuestionId={newQuestionId}")]
        public Boolean STD_QUESTION_COPY_CHOICES_JSON(string identity, int registryId, int oldQuestionId, int newQuestionId)
        {
            return this.STD_QUESTION_COPY_CHOICES(identity, registryId, oldQuestionId, newQuestionId);
        }

        #endregion

        #region STD_QUESTION_CHOICE

        [WebMethod]
        public STD_QUESTION_CHOICE STD_QUESTION_CHOICE_GET(string identity, int registryId, int id)
        {
            return VIRPManager.STD_QUESTION_CHOICE_GET(identity, registryId, id);
        }

        [WebMethod]
        public int STD_QUESTION_CHOICE_SAVE(string identity, int registryId, STD_QUESTION_CHOICE objSave)
        {
            return VIRPManager.STD_QUESTION_CHOICE_SAVE(identity, registryId, objSave);
        }

        [WebMethod]
        public Boolean STD_QUESTION_CHOICE_DELETE(string identity, int registryId, int id)
        {
            return VIRPManager.STD_QUESTION_CHOICE_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_QUESTION_CHOICE_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_QUESTION_CHOICE STD_QUESTION_CHOICE_GET_XML(string identity, int registryId, int id)
        {
            return this.STD_QUESTION_CHOICE_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_QUESTION_CHOICE_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_QUESTION_CHOICE_SAVE_XML(string identity, int registryId, STD_QUESTION_CHOICE objSave)
        {
            return this.STD_QUESTION_CHOICE_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_QUESTION_CHOICE_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_QUESTION_CHOICE_DELETE_XML(string identity, int registryId, int id)
        {
            return this.STD_QUESTION_CHOICE_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_QUESTION_CHOICE_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_QUESTION_CHOICE STD_QUESTION_CHOICE_GET_JSON(string identity, int registryId, int id)
        {
            return this.STD_QUESTION_CHOICE_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_QUESTION_CHOICE_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_QUESTION_CHOICE_SAVE_JSON(string identity, int registryId, STD_QUESTION_CHOICE objSave)
        {
            return this.STD_QUESTION_CHOICE_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_QUESTION_CHOICE_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_QUESTION_CHOICE_DELETE_JSON(string identity, int registryId, int id)
        {
            return this.STD_QUESTION_CHOICE_DELETE(identity, registryId, id);
        }

        [WebMethod]
        public List<STD_QUESTION_CHOICE> STD_QUESTION_CHOICE_GET_ALL_BY_QUESTION(string identity, int registryId, int questionId)
        {
            return VIRPManager.STD_QUESTION_CHOICE_GET_ALL_BY_QUESTION(identity, registryId, questionId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_QUESTION_CHOICE_GET_ALL_BY_QUESTION?identity={identity}&registryId={registryId}&questionId={questionId}")]
        public List<STD_QUESTION_CHOICE> STD_QUESTION_CHOICE_GET_ALL_BY_QUESTION_XML(string identity, int registryId, int questionId)
        {
            return this.STD_QUESTION_CHOICE_GET_ALL_BY_QUESTION(identity, registryId, questionId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_QUESTION_CHOICE_GET_ALL_BY_QUESTION?identity={identity}&registryId={registryId}&questionId={questionId}")]
        public List<STD_QUESTION_CHOICE> STD_QUESTION_CHOICE_GET_ALL_BY_QUESTION_JSON(string identity, int registryId, int questionId)
        {
            return this.STD_QUESTION_CHOICE_GET_ALL_BY_QUESTION(identity, registryId, questionId);
        }

        #endregion

        #region STD_REFERRALSTS

        [WebMethod]
        public STD_REFERRALSTS STD_REFERRALSTS_GET_BY_CODE(string identity, int registryId, string code)
        {
            return VIRPManager.STD_REFERRALSTS_GET_BY_CODE(identity, registryId, code);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_REFERRALSTS_GET_BY_CODE?identity={identity}&registryId={registryId}&code={code}")]
        public STD_REFERRALSTS STD_REFERRALSTS_GET_BY_CODE_XML(string identity, int registryId, string code)
        {
            return this.STD_REFERRALSTS_GET_BY_CODE(identity, registryId, code);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_REFERRALSTS_GET_BY_CODE?identity={identity}&registryId={registryId}&code={code}")]
        public STD_REFERRALSTS STD_REFERRALSTS_GET_BY_CODE_JSON(string identity, int registryId, string code)
        {
            return this.STD_REFERRALSTS_GET_BY_CODE(identity, registryId, code);
        }

        #endregion

        #region STD_REG_UDFs

        [WebMethod]
        public STD_REG_UDFs STD_REG_UDFs_GET(string identity, int registryId, int id)
        {
            return VIRPManager.STD_REG_UDFs_GET(identity, registryId, id);
        }

        [WebMethod]
        public int STD_REG_UDFs_SAVE(string identity, int registryId, STD_REG_UDFs objSave)
        {
            return VIRPManager.STD_REG_UDFs_SAVE(identity, registryId, objSave);
        }

        [WebMethod]
        public Boolean STD_REG_UDFs_DELETE(string identity, int registryId, int id)
        {
            return VIRPManager.STD_REG_UDFs_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_REG_UDFs_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_REG_UDFs STD_REG_UDFs_GET_XML(string identity, int registryId, int id)
        {
            return this.STD_REG_UDFs_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_REG_UDFs_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_REG_UDFs_SAVE_XML(string identity, int registryId, STD_REG_UDFs objSave)
        {
            return this.STD_REG_UDFs_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_REG_UDFs_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_REG_UDFs_DELETE_XML(string identity, int registryId, int id)
        {
            return this.STD_REG_UDFs_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_REG_UDFs_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_REG_UDFs STD_REG_UDFs_GET_JSON(string identity, int registryId, int id)
        {
            return this.STD_REG_UDFs_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_REG_UDFs_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_REG_UDFs_SAVE_JSON(string identity, int registryId, STD_REG_UDFs objSave)
        {
            return this.STD_REG_UDFs_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_REG_UDFs_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_REG_UDFs_DELETE_JSON(string identity, int registryId, int id)
        {
            return this.STD_REG_UDFs_DELETE(identity, registryId, id);
        }

        [WebMethod]
        public List<STD_REG_UDFs> STD_REG_UDFs_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.STD_REG_UDFs_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_REG_UDFs_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<STD_REG_UDFs> STD_REG_UDFs_GET_ALL_BY_REGISTRY_XML(string identity, int registryId)
        {
            return this.STD_REG_UDFs_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_REG_UDFs_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<STD_REG_UDFs> STD_REG_UDFs_GET_ALL_BY_REGISTRY_JSON(string identity, int registryId)
        {
            return this.STD_REG_UDFs_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        #endregion

        #region STD_REGISTRY

        [WebMethod]
        public STD_REGISTRY STD_REGISTRY_GET(string identity, int registryId, int id)
        {
            return VIRPManager.STD_REGISTRY_GET(identity, registryId, id);
        }

        [WebMethod]
        public int STD_REGISTRY_SAVE(string identity, int registryId, STD_REGISTRY objSave)
        {
            return VIRPManager.STD_REGISTRY_SAVE(identity, registryId, objSave);
        }

        [WebMethod]
        public Boolean STD_REGISTRY_DELETE(string identity, int registryId, int id)
        {
            return VIRPManager.STD_REGISTRY_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_REGISTRY_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_REGISTRY STD_REGISTRY_GET_XML(string identity, int registryId, int id)
        {
            return this.STD_REGISTRY_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_REGISTRY_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_REGISTRY_SAVE_XML(string identity, int registryId, STD_REGISTRY objSave)
        {
            return this.STD_REGISTRY_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_REGISTRY_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_REGISTRY_DELETE_XML(string identity, int registryId, int id)
        {
            return this.STD_REGISTRY_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_REGISTRY_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_REGISTRY STD_REGISTRY_GET_JSON(string identity, int registryId, int id)
        {
            return this.STD_REGISTRY_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_REGISTRY_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_REGISTRY_SAVE_JSON(string identity, int registryId, STD_REGISTRY objSave)
        {
            return this.STD_REGISTRY_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_REGISTRY_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_REGISTRY_DELETE_JSON(string identity, int registryId, int id)
        {
            return this.STD_REGISTRY_DELETE(identity, registryId, id);
        }

        [WebMethod]
        public STD_REGISTRY STD_REGISTRY_GET_COMPLETE(string identity, int registryId, int id)
        {
            return VIRPManager.STD_REGISTRY_GET_COMPLETE(identity, registryId, id);
        }

        [WebMethod]
        public STD_REGISTRY STD_REGISTRY_GET_SYSTEM()
        {
            return VIRPManager.STD_REGISTRY_GET_SYSTEM();
        }

        [WebMethod]
        public List<STD_REGISTRY> STD_REGISTRY_GET_ALL_BY_USER(string identity, int registryId)
        {
            return VIRPManager.STD_REGISTRY_GET_ALL_BY_USER(identity, registryId);
        }

        [WebMethod]
        public List<STD_REGISTRY> STD_REGISTRY_GET_ALL_NON_SYSTEM()
        {
            return VIRPManager.STD_REGISTRY_GET_ALL_NON_SYSTEM();
        }

        [WebMethod]
        public List<STD_REGISTRY> STD_REGISTRY_GET_ALL_NON_SYSTEM_BY_USER(string identity, int registryId)
        {
            return VIRPManager.STD_REGISTRY_GET_ALL_NON_SYSTEM_BY_USER(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_REGISTRY_GET_COMPLETE?identity={identity}&registryId={registryId}&id={id}")]
        public STD_REGISTRY STD_REGISTRY_GET_COMPLETE_XML(string identity, int registryId, int id)
        {
            return this.STD_REGISTRY_GET_COMPLETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_REGISTRY_GET_SYSTEM")]
        public STD_REGISTRY STD_REGISTRY_GET_SYSTEM_XML()
        {
            return this.STD_REGISTRY_GET_SYSTEM();
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_REGISTRY_GET_ALL_BY_USER?identity={identity}&registryId={registryId}")]
        public List<STD_REGISTRY> STD_REGISTRY_GET_ALL_BY_USER_XML(string identity, int registryId)
        {
            return this.STD_REGISTRY_GET_ALL_BY_USER(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_REGISTRY_GET_ALL_NON_SYSTEM")]
        public List<STD_REGISTRY> STD_REGISTRY_GET_ALL_NON_SYSTEM_XML()
        {
            return this.STD_REGISTRY_GET_ALL_NON_SYSTEM();
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_REGISTRY_GET_ALL_NON_SYSTEM_BY_USER?identity={identity}&registryId={registryId}")]
        public List<STD_REGISTRY> STD_REGISTRY_GET_ALL_NON_SYSTEM_BY_USER_XML(string identity, int registryId)
        {
            return this.STD_REGISTRY_GET_ALL_NON_SYSTEM_BY_USER(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_REGISTRY_GET_COMPLETE?identity={identity}&registryId={registryId}&id={id}")]
        public STD_REGISTRY STD_REGISTRY_GET_COMPLETE_JSON(string identity, int registryId, int id)
        {
            return this.STD_REGISTRY_GET_COMPLETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_REGISTRY_GET_SYSTEM")]
        public STD_REGISTRY STD_REGISTRY_GET_SYSTEM_JSON()
        {
            return this.STD_REGISTRY_GET_SYSTEM();
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_REGISTRY_GET_ALL_BY_USER?identity={identity}&registryId={registryId}")]
        public List<STD_REGISTRY> STD_REGISTRY_GET_ALL_BY_USER_JSON(string identity, int registryId)
        {
            return this.STD_REGISTRY_GET_ALL_BY_USER(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_REGISTRY_GET_ALL_NON_SYSTEM")]
        public List<STD_REGISTRY> STD_REGISTRY_GET_ALL_NON_SYSTEM_JSON()
        {
            return this.STD_REGISTRY_GET_ALL_NON_SYSTEM();
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_REGISTRY_GET_ALL_NON_SYSTEM_BY_USER?identity={identity}&registryId={registryId}")]
        public List<STD_REGISTRY> STD_REGISTRY_GET_ALL_NON_SYSTEM_BY_USER_JSON(string identity, int registryId)
        {
            return this.STD_REGISTRY_GET_ALL_NON_SYSTEM_BY_USER(identity, registryId);
        }

        #endregion

        #region STD_ROLE

        [WebMethod]
        public STD_ROLE STD_ROLE_GET(string identity, int registryId, int id)
        {
            return VIRPManager.STD_ROLE_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_ROLE_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_ROLE STD_ROLE_GET_XML(string identity, int registryId, int id)
        {
            return this.STD_ROLE_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_ROLE_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_ROLE STD_ROLE_GET_JSON(string identity, int registryId, int id)
        {
            return this.STD_ROLE_GET(identity, registryId, id);
        }

        [WebMethod]
        public List<STD_ROLE> STD_ROLE_GET_ALL_SYSTEM_ROLES(string identity, int registryId)
        {
            return VIRPManager.STD_ROLE_GET_ALL_SYSTEM_ROLES(identity, registryId);
        }

        [WebMethod]
        public List<STD_ROLE> STD_ROLE_GET_ALL_REGISTRY_ROLES(string identity, int registryId)
        {
            return VIRPManager.STD_ROLE_GET_ALL_REGISTRY_ROLES(identity, registryId);
        }

        [WebMethod]
        public List<STD_ROLE> STD_ROLE_GET_ALL_BY_USER_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.STD_ROLE_GET_ALL_BY_USER_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_ROLE_GET_ALL_SYSTEM_ROLES?identity={identity}&registryId={registryId}")]
        public List<STD_ROLE> STD_ROLE_GET_ALL_SYSTEM_ROLES_XML(string identity, int registryId)
        {
            return this.STD_ROLE_GET_ALL_SYSTEM_ROLES(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_ROLE_GET_ALL_REGISTRY_ROLES?identity={identity}&registryId={registryId}")]
        public List<STD_ROLE> STD_ROLE_GET_ALL_REGISTRY_ROLES_XML(string identity, int registryId)
        {
            return this.STD_ROLE_GET_ALL_REGISTRY_ROLES(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_ROLE_GET_ALL_BY_USER_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<STD_ROLE> STD_ROLE_GET_ALL_BY_USER_REGISTRY_XML(string identity, int registryId)
        {
            return this.STD_ROLE_GET_ALL_BY_USER_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_ROLE_GET_ALL_SYSTEM_ROLES?identity={identity}&registryId={registryId}")]
        public List<STD_ROLE> STD_ROLE_GET_ALL_SYSTEM_ROLES_JSON(string identity, int registryId)
        {
            return this.STD_ROLE_GET_ALL_SYSTEM_ROLES(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_ROLE_GET_ALL_REGISTRY_ROLES?identity={identity}&registryId={registryId}")]
        public List<STD_ROLE> STD_ROLE_GET_ALL_REGISTRY_ROLES_JSON(string identity, int registryId)
        {
            return this.STD_ROLE_GET_ALL_REGISTRY_ROLES(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_ROLE_GET_ALL_BY_USER_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<STD_ROLE> STD_ROLE_GET_ALL_BY_USER_REGISTRY_JSON(string identity, int registryId)
        {
            return this.STD_ROLE_GET_ALL_BY_USER_REGISTRY(identity, registryId);
        }

        #endregion

        #region STD_SURVEY_TYPE

        [WebMethod]
        public STD_SURVEY_TYPE STD_SURVEY_TYPE_GET(string identity, int registryId, int id)
        {
            return VIRPManager.STD_SURVEY_TYPE_GET(identity, registryId, id);
        }

        [WebMethod]
        public int STD_SURVEY_TYPE_SAVE(string identity, int registryId, STD_SURVEY_TYPE objSave)
        {
            return VIRPManager.STD_SURVEY_TYPE_SAVE(identity, registryId, objSave);
        }

        [WebMethod]
        public Boolean STD_SURVEY_TYPE_DELETE(string identity, int registryId, int id)
        {
            return VIRPManager.STD_SURVEY_TYPE_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_SURVEY_TYPE_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_SURVEY_TYPE STD_SURVEY_TYPE_GET_XML(string identity, int registryId, int id)
        {
            return this.STD_SURVEY_TYPE_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_SURVEY_TYPE_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_SURVEY_TYPE_SAVE_XML(string identity, int registryId, STD_SURVEY_TYPE objSave)
        {
            return this.STD_SURVEY_TYPE_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_SURVEY_TYPE_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_SURVEY_TYPE_DELETE_XML(string identity, int registryId, int id)
        {
            return this.STD_SURVEY_TYPE_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_SURVEY_TYPE_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_SURVEY_TYPE STD_SURVEY_TYPE_GET_JSON(string identity, int registryId, int id)
        {
            return this.STD_SURVEY_TYPE_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_SURVEY_TYPE_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_SURVEY_TYPE_SAVE_JSON(string identity, int registryId, STD_SURVEY_TYPE objSave)
        {
            return this.STD_SURVEY_TYPE_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_SURVEY_TYPE_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_SURVEY_TYPE_DELETE_JSON(string identity, int registryId, int id)
        {
            return this.STD_SURVEY_TYPE_DELETE(identity, registryId, id);
        }

        [WebMethod]
        public List<STD_SURVEY_TYPE> STD_SURVEY_TYPE_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.STD_SURVEY_TYPE_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_SURVEY_TYPE_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<STD_SURVEY_TYPE> STD_SURVEY_TYPE_GET_ALL_BY_REGISTRY_XML(string identity, int registryId)
        {
            return this.STD_SURVEY_TYPE_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_SURVEY_TYPE_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<STD_SURVEY_TYPE> STD_SURVEY_TYPE_GET_ALL_BY_REGISTRY_JSON(string identity, int registryId)
        {
            return this.STD_SURVEY_TYPE_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        #endregion

        #region STD_WEB_PAGES

        [WebMethod]
        public STD_WEB_PAGES STD_WEB_PAGES_GET(string identity, int registryId, int id)
        {
            return VIRPManager.STD_WEB_PAGES_GET(identity, registryId, id);
        }

        [WebMethod]
        public List<STD_WEB_PAGES> STD_WEB_PAGES_GET_ALL(string identity, int registryId)
        {
            return VIRPManager.STD_WEB_PAGES_GET_ALL(identity, registryId);
        }

        [WebMethod]
        public int STD_WEB_PAGES_SAVE(string identity, int registryId, STD_WEB_PAGES objSave)
        {
            return VIRPManager.STD_WEB_PAGES_SAVE(identity, registryId, objSave);
        }

        [WebMethod]
        public Boolean STD_WEB_PAGES_DELETE(string identity, int registryId, int id)
        {
            return VIRPManager.STD_WEB_PAGES_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_WEB_PAGES_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_WEB_PAGES STD_WEB_PAGES_GET_XML(string identity, int registryId, int id)
        {
            return this.STD_WEB_PAGES_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_WEB_PAGES_GET_ALL?identity={identity}&registryId={registryId}")]
        public List<STD_WEB_PAGES> STD_WEB_PAGES_GET_ALL_XML(string identity, int registryId)
        {
            return this.STD_WEB_PAGES_GET_ALL(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_WEB_PAGES_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_WEB_PAGES_SAVE_XML(string identity, int registryId, STD_WEB_PAGES objSave)
        {
            return this.STD_WEB_PAGES_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_WEB_PAGES_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_WEB_PAGES_DELETE_XML(string identity, int registryId, int id)
        {
            return this.STD_WEB_PAGES_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_WEB_PAGES_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_WEB_PAGES STD_WEB_PAGES_GET_JSON(string identity, int registryId, int id)
        {
            return this.STD_WEB_PAGES_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_WEB_PAGES_GET_ALL?identity={identity}&registryId={registryId}")]
        public List<STD_WEB_PAGES> STD_WEB_PAGES_GET_ALL_JSON(string identity, int registryId)
        {
            return this.STD_WEB_PAGES_GET_ALL(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_WEB_PAGES_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_WEB_PAGES_SAVE_JSON(string identity, int registryId, STD_WEB_PAGES objSave)
        {
            return this.STD_WEB_PAGES_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_WEB_PAGES_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_WEB_PAGES_DELETE_JSON(string identity, int registryId, int id)
        {
            return this.STD_WEB_PAGES_DELETE(identity, registryId, id);
        }

        #endregion

        #region STD_WKFACTIVITYSTS

        [WebMethod]
        public STD_WKFACTIVITYSTS STD_WKFACTIVITYSTS_GET(string identity, int registryId, int id)
        {
            return VIRPManager.STD_WKFACTIVITYSTS_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_WKFACTIVITYSTS_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_WKFACTIVITYSTS STD_WKFACTIVITYSTS_GET_XML(string identity, int registryId, int id)
        {
            return this.STD_WKFACTIVITYSTS_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_WKFACTIVITYSTS_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_WKFACTIVITYSTS STD_WKFACTIVITYSTS_GET_JSON(string identity, int registryId, int id)
        {
            return this.STD_WKFACTIVITYSTS_GET(identity, registryId, id);
        }

        [WebMethod]
        public STD_WKFACTIVITYSTS STD_WKFACTIVITYSTS_GET_BY_CODE(string identity, int registryId, string code)
        {
            return VIRPManager.STD_WKFACTIVITYSTS_GET_BY_CODE(identity, registryId, code);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_WKFACTIVITYSTS_GET_BY_CODE?identity={identity}&registryId={registryId}&code={code}")]
        public STD_WKFACTIVITYSTS STD_WKFACTIVITYSTS_GET_BY_CODE_XML(string identity, int registryId, string code)
        {
            return this.STD_WKFACTIVITYSTS_GET_BY_CODE(identity, registryId, code);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_WKFACTIVITYSTS_GET_BY_CODE?identity={identity}&registryId={registryId}&code={code}")]
        public STD_WKFACTIVITYSTS STD_WKFACTIVITYSTS_GET_BY_CODE_JSON(string identity, int registryId, string code)
        {
            return this.STD_WKFACTIVITYSTS_GET_BY_CODE(identity, registryId, code);
        }

        #endregion

        #region STD_WKFACTIVITYTYPE

        [WebMethod]
        public STD_WKFACTIVITYTYPE STD_WKFACTIVITYTYPE_GET(string identity, int registryId, int id)
        {
            return VIRPManager.STD_WKFACTIVITYTYPE_GET(identity, registryId, id);
        }

        [WebMethod]
        public int STD_WKFACTIVITYTYPE_SAVE(string identity, int registryId, STD_WKFACTIVITYTYPE objSave)
        {
            return VIRPManager.STD_WKFACTIVITYTYPE_SAVE(identity, registryId, objSave);
        }

        [WebMethod]
        public Boolean STD_WKFACTIVITYTYPE_DELETE(string identity, int registryId, int id)
        {
            return VIRPManager.STD_WKFACTIVITYTYPE_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_WKFACTIVITYTYPE_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_WKFACTIVITYTYPE STD_WKFACTIVITYTYPE_GET_XML(string identity, int registryId, int id)
        {
            return this.STD_WKFACTIVITYTYPE_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_WKFACTIVITYTYPE_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_WKFACTIVITYTYPE_SAVE_XML(string identity, int registryId, STD_WKFACTIVITYTYPE objSave)
        {
            return this.STD_WKFACTIVITYTYPE_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_WKFACTIVITYTYPE_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_WKFACTIVITYTYPE_DELETE_XML(string identity, int registryId, int id)
        {
            return this.STD_WKFACTIVITYTYPE_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_WKFACTIVITYTYPE_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_WKFACTIVITYTYPE STD_WKFACTIVITYTYPE_GET_JSON(string identity, int registryId, int id)
        {
            return this.STD_WKFACTIVITYTYPE_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_WKFACTIVITYTYPE_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_WKFACTIVITYTYPE_SAVE_JSON(string identity, int registryId, STD_WKFACTIVITYTYPE objSave)
        {
            return this.STD_WKFACTIVITYTYPE_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_WKFACTIVITYTYPE_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_WKFACTIVITYTYPE_DELETE_JSON(string identity, int registryId, int id)
        {
            return this.STD_WKFACTIVITYTYPE_DELETE(identity, registryId, id);
        }

        [WebMethod]
        public List<STD_WKFACTIVITYTYPE> STD_WKFACTIVITYTYPE_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.STD_WKFACTIVITYTYPE_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [WebMethod]
        public List<STD_WKFACTIVITYTYPE> STD_WKFACTIVITYTYPE_GET_ALL_BY_WORKSTREAM(string identity, int registryId, int streamId)
        {
            return VIRPManager.STD_WKFACTIVITYTYPE_GET_ALL_BY_WORKSTREAM(identity, registryId, streamId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_WKFACTIVITYTYPE_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<STD_WKFACTIVITYTYPE> STD_WKFACTIVITYTYPE_GET_ALL_BY_REGISTRY_XML(string identity, int registryId)
        {
            return this.STD_WKFACTIVITYTYPE_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_WKFACTIVITYTYPE_GET_ALL_BY_WORKSTREAM?identity={identity}&registryId={registryId}&streamId={streamId}")]
        public List<STD_WKFACTIVITYTYPE> STD_WKFACTIVITYTYPE_GET_ALL_BY_WORKSTREAM_XML(string identity, int registryId, int streamId)
        {
            return this.STD_WKFACTIVITYTYPE_GET_ALL_BY_WORKSTREAM(identity, registryId, streamId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_WKFACTIVITYTYPE_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<STD_WKFACTIVITYTYPE> STD_WKFACTIVITYTYPE_GET_ALL_BY_REGISTRY_JSON(string identity, int registryId)
        {
            return this.STD_WKFACTIVITYTYPE_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_WKFACTIVITYTYPE_GET_ALL_BY_WORKSTREAM?identity={identity}&registryId={registryId}&streamId={streamId}")]
        public List<STD_WKFACTIVITYTYPE> STD_WKFACTIVITYTYPE_GET_ALL_BY_WORKSTREAM_JSON(string identity, int registryId, int streamId)
        {
            return this.STD_WKFACTIVITYTYPE_GET_ALL_BY_WORKSTREAM(identity, registryId, streamId);
        }

        #endregion

        #region STD_WKFCASESTS

        [WebMethod]
        public STD_WKFCASESTS STD_WKFCASESTS_GET(string identity, int registryId, int id)
        {
            return VIRPManager.STD_WKFCASESTS_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_WKFCASESTS_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_WKFCASESTS STD_WKFCASESTS_GET_XML(string identity, int registryId, int id)
        {
            return this.STD_WKFCASESTS_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_WKFCASESTS_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_WKFCASESTS STD_WKFCASESTS_GET_JSON(string identity, int registryId, int id)
        {
            return this.STD_WKFCASESTS_GET(identity, registryId, id);
        }

        [WebMethod]
        public STD_WKFCASESTS STD_WKFCASESTS_GET_BY_CODE(string identity, int registryId, string code)
        {
            return VIRPManager.STD_WKFCASESTS_GET_BY_CODE(identity, registryId, code);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_WKFCASESTS_GET_BY_CODE?identity={identity}&registryId={registryId}&code={code}")]
        public STD_WKFCASESTS STD_WKFCASESTS_GET_BY_CODE_XML(string identity, int registryId, string code)
        {
            return this.STD_WKFCASESTS_GET_BY_CODE(identity, registryId, code);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_WKFCASESTS_GET_BY_CODE?identity={identity}&registryId={registryId}&code={code}")]
        public STD_WKFCASESTS STD_WKFCASESTS_GET_BY_CODE_JSON(string identity, int registryId, string code)
        {
            return this.STD_WKFCASESTS_GET_BY_CODE(identity, registryId, code);
        }

        #endregion

        #region STD_WKFCASETYPE

        [WebMethod]
        public STD_WKFCASETYPE STD_WKFCASETYPE_GET(string identity, int registryId, int id)
        {
            return VIRPManager.STD_WKFCASETYPE_GET(identity, registryId, id);
        }

        [WebMethod]
        public int STD_WKFCASETYPE_SAVE(string identity, int registryId, STD_WKFCASETYPE objSave)
        {
            return VIRPManager.STD_WKFCASETYPE_SAVE(identity, registryId, objSave);
        }

        [WebMethod]
        public Boolean STD_WKFCASETYPE_DELETE(string identity, int registryId, int id)
        {
            return VIRPManager.STD_WKFCASETYPE_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_WKFCASETYPE_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_WKFCASETYPE STD_WKFCASETYPE_GET_XML(string identity, int registryId, int id)
        {
            return this.STD_WKFCASETYPE_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_WKFCASETYPE_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_WKFCASETYPE_SAVE_XML(string identity, int registryId, STD_WKFCASETYPE objSave)
        {
            return this.STD_WKFCASETYPE_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_WKFCASETYPE_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_WKFCASETYPE_DELETE_XML(string identity, int registryId, int id)
        {
            return this.STD_WKFCASETYPE_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_WKFCASETYPE_GET?identity={identity}&registryId={registryId}&id={id}")]
        public STD_WKFCASETYPE STD_WKFCASETYPE_GET_JSON(string identity, int registryId, int id)
        {
            return this.STD_WKFCASETYPE_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_WKFCASETYPE_SAVE?identity={identity}&registryId={registryId}")]
        public int STD_WKFCASETYPE_SAVE_JSON(string identity, int registryId, STD_WKFCASETYPE objSave)
        {
            return this.STD_WKFCASETYPE_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_WKFCASETYPE_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean STD_WKFCASETYPE_DELETE_JSON(string identity, int registryId, int id)
        {
            return this.STD_WKFCASETYPE_DELETE(identity, registryId, id);
        }

        [WebMethod]
        public List<STD_WKFCASETYPE> STD_WKFCASETYPE_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.STD_WKFCASETYPE_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/STD_WKFCASETYPE_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<STD_WKFCASETYPE> STD_WKFCASETYPE_GET_ALL_BY_REGISTRY_XML(string identity, int registryId)
        {
            return this.STD_WKFCASETYPE_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/STD_WKFCASETYPE_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<STD_WKFCASETYPE> STD_WKFCASETYPE_GET_ALL_BY_REGISTRY_JSON(string identity, int registryId)
        {
            return this.STD_WKFCASETYPE_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        #endregion

        #region SURVEY_RESULTS

        [WebMethod]
        public List<SURVEY_RESULTS> SURVEY_RESULTS_GET_ALL_BY_SURVEY(string identity, int registryId, int surveyId)
        {
            return VIRPManager.SURVEY_RESULTS_GET_ALL_BY_SURVEY(identity, registryId, surveyId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/SURVEY_RESULTS_GET_ALL_BY_SURVEY?identity={identity}&registryId={registryId}&surveyId={surveyId}")]
        public List<SURVEY_RESULTS> SURVEY_RESULTS_GET_ALL_BY_SURVEY_XML(string identity, int registryId, int surveyId)
        {
            return this.SURVEY_RESULTS_GET_ALL_BY_SURVEY(identity, registryId, surveyId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/SURVEY_RESULTS_GET_ALL_BY_SURVEY?identity={identity}&registryId={registryId}&surveyId={surveyId}")]
        public List<SURVEY_RESULTS> SURVEY_RESULTS_GET_ALL_BY_SURVEY_JSON(string identity, int registryId, int surveyId)
        {
            return this.SURVEY_RESULTS_GET_ALL_BY_SURVEY(identity, registryId, surveyId);
        }

        [WebMethod]
        public Boolean SURVEY_RESULTS_SAVE_ALL(string identity, int registryId, SURVEY_RESULTS[] results)
        {
            return VIRPManager.SURVEY_RESULTS_SAVE_ALL(identity, registryId, results);
        }

        [OperationContract]
        [WebInvoke(Method = "POST", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/SURVEY_RESULTS_SAVE_ALL?identity={identity}&registryId={registryId}&surveyId={surveyId}&results={results}")]
        public Boolean SURVEY_RESULTS_SAVE_ALL_XML(string identity, int registryId, SURVEY_RESULTS[] results)
        {
            return this.SURVEY_RESULTS_SAVE_ALL(identity, registryId, results);
        }

        [OperationContract]
        [WebInvoke(Method = "POST", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/SURVEY_RESULTS_SAVE_ALL?identity={identity}&registryId={registryId}&surveyId={surveyId}&surveyId={surveyId}")]
        public Boolean SURVEY_RESULTS_SAVE_ALL_JSON(string identity, int registryId, SURVEY_RESULTS[] results)
        {
            return this.SURVEY_RESULTS_SAVE_ALL(identity, registryId, results);
        }

        #endregion

        #region SURVEYS

        [WebMethod]
        public SURVEYS SURVEYS_GET(string identity, int registryId, int id)
        {
            return VIRPManager.SURVEYS_GET(identity, registryId, id);
        }

        [WebMethod]
        public int SURVEYS_SAVE(string identity, int registryId, SURVEYS objSave)
        {
            return VIRPManager.SURVEYS_SAVE(identity, registryId, objSave);
        }

        [WebMethod]
        public Boolean SURVEYS_DELETE(string identity, int registryId, int id)
        {
            return VIRPManager.SURVEYS_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/SURVEYS_GET?identity={identity}&registryId={registryId}&id={id}")]
        public SURVEYS SURVEYS_GET_XML(string identity, int registryId, int id)
        {
            return this.SURVEYS_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/SURVEYS_SAVE?identity={identity}&registryId={registryId}")]
        public int SURVEYS_SAVE_XML(string identity, int registryId, SURVEYS objSave)
        {
            return this.SURVEYS_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/SURVEYS_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean SURVEYS_DELETE_XML(string identity, int registryId, int id)
        {
            return this.SURVEYS_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/SURVEYS_GET?identity={identity}&registryId={registryId}&id={id}")]
        public SURVEYS SURVEYS_GET_JSON(string identity, int registryId, int id)
        {
            return this.SURVEYS_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/SURVEYS_SAVE?identity={identity}&registryId={registryId}")]
        public int SURVEYS_SAVE_JSON(string identity, int registryId, SURVEYS objSave)
        {
            return this.SURVEYS_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/SURVEYS_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean SURVEYS_DELETE_JSON(string identity, int registryId, int id)
        {
            return this.SURVEYS_DELETE(identity, registryId, id);
        }

        [WebMethod]
        public SURVEYS SURVEYS_GET_FOR_SURVEY(string identity, int registryId, int surveysId)
        {
            return VIRPManager.SURVEYS_GET_FOR_SURVEY(identity, registryId, surveysId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/SURVEYS_GET_FOR_SURVEY?identity={identity}&registryId={registryId}&surveysId={surveysId}")]
        public SURVEYS SURVEYS_GET_FOR_SURVEY_XML(string identity, int registryId, int surveysId)
        {
            return this.SURVEYS_GET_FOR_SURVEY(identity, registryId, surveysId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/SURVEYS_GET_FOR_SURVEY?identity={identity}&registryId={registryId}&surveysId={surveysId}")]
        public SURVEYS SURVEYS_GET_FOR_SURVEY_JSON(string identity, int registryId, int surveysId)
        {
            return this.SURVEYS_GET_FOR_SURVEY(identity, registryId, surveysId);
        }

        [WebMethod]
        public List<SURVEYS> SURVEYS_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.SURVEYS_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/SURVEYS_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<SURVEYS> SURVEYS_GET_ALL_BY_REGISTRY_XML(string identity, int registryId)
        {
            return this.SURVEYS_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/SURVEYS_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<SURVEYS> SURVEYS_GET_ALL_BY_REGISTRY_JSON(string identity, int registryId)
        {
            return this.SURVEYS_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        #endregion

        #region USER_ROLES

        [WebMethod]
        public USER_ROLES USER_ROLES_GET_BY_USERID_ROLEID(string identity, int registryId, int userId, int roleId)
        {
            return VIRPManager.USER_ROLES_GET_BY_USERID_ROLEID(identity, registryId, userId, roleId);
        }

        [WebMethod]
        public List<string> USER_ROLES_GET_BY_REGISTRYID_USERNAME(string username, int registryId)
        {
            return VIRPManager.USER_ROLES_GET_BY_REGISTRYID_USERNAME(username, registryId);
        }

        [WebMethod]
        public USER_ROLES USER_ROLES_GET_BY_USER_ROLE(string username, string rolename)
        {
            return VIRPManager.USER_ROLES_GET_BY_USER_ROLE(username, rolename);
        }

        [WebMethod]
        public string[] USER_ROLES_GET_ROLES(string username)
        {
            return VIRPManager.USER_ROLES_GET_ROLES(username);
        }

        [WebMethod]
        public List<USER_ROLES> USER_ROLES_GET_ALL_BY_USER(string identity, int registryId, int userId)
        {
            return VIRPManager.USER_ROLES_GET_ALL_BY_USER(identity, registryId, userId);
        }

        [WebMethod]
        public bool USER_ROLES_DELETE_BY_USER_REGISTRY(string identity, int registryId, int userId, int stdRegistryId)
        {
            return VIRPManager.USER_ROLES_DELETE_BY_USER_REGISTRY(identity, registryId, userId, stdRegistryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/USER_ROLES_GET_BY_USERID_ROLEID?identity={identity}&registryId={registryId}&userId={userId}&roleId={roleId}")]
        public USER_ROLES USER_ROLES_GET_BY_USERID_ROLEID_XML(string identity, int registryId, int userId, int roleId)
        {
            return this.USER_ROLES_GET_BY_USERID_ROLEID(identity, registryId, userId, roleId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/USER_ROLES_GET_BY_USER_ROLE?username={username}&rolename={rolename}")]
        public USER_ROLES USER_ROLES_GET_BY_USER_ROLE_XML(string username, string rolename)
        {
            return this.USER_ROLES_GET_BY_USER_ROLE(username, rolename);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/USER_ROLES_GET_ROLES?username={username}")]
        public string[] USER_ROLES_GET_ROLES_XML(string username)
        {
            return this.USER_ROLES_GET_ROLES(username);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/USER_ROLES_GET_ALL_BY_USER?identity={identity}&registryId={registryId}&userId={userId}")]
        public List<USER_ROLES> USER_ROLES_GET_ALL_BY_USER_XML(string identity, int registryId, int userId)
        {
            return this.USER_ROLES_GET_ALL_BY_USER(identity, registryId, userId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/USER_ROLES_DELETE_BY_USER_REGISTRY?identity={identity}&registryId={registryId}&stdRegistryId={stdRegistryId}")]
        public bool USER_ROLES_DELETE_BY_USER_REGISTRY_XML(string identity, int registryId, int userId, int stdRegistryId)
        {
            return this.USER_ROLES_DELETE_BY_USER_REGISTRY(identity, registryId, userId, stdRegistryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/USER_ROLES_GET_BY_USERID_ROLEID?identity={identity}&registryId={registryId}&userId={userId}&roleId={roleId}")]
        public USER_ROLES USER_ROLES_GET_BY_USERID_ROLEID_JSON(string identity, int registryId, int userId, int roleId)
        {
            return this.USER_ROLES_GET_BY_USERID_ROLEID(identity, registryId, userId, roleId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/USER_ROLES_GET_BY_USER_ROLE?username={username}&rolename={rolename}")]
        public USER_ROLES USER_ROLES_GET_BY_USER_ROLE_JSON(string username, string rolename)
        {
            return this.USER_ROLES_GET_BY_USER_ROLE(username, rolename);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/USER_ROLES_GET_ROLES?username={username}")]
        public string[] USER_ROLES_GET_ROLES_JSON(string username)
        {
            return this.USER_ROLES_GET_ROLES(username);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/USER_ROLES_GET_ALL_BY_USER?identity={identity}&registryId={registryId}&userId={userId}")]
        public List<USER_ROLES> USER_ROLES_GET_ALL_BY_USER_JSON(string identity, int registryId, int userId)
        {
            return this.USER_ROLES_GET_ALL_BY_USER(identity, registryId, userId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/USER_ROLES_DELETE_BY_USER_REGISTRY?identity={identity}&registryId={registryId}&userId={userId}&stdRegistryId={stdRegistryId}")]
        public bool USER_ROLES_DELETE_BY_USER_REGISTRY_JSON(string identity, int registryId, int userId, int stdRegistryId)
        {
            return this.USER_ROLES_DELETE_BY_USER_REGISTRY(identity, registryId, userId, stdRegistryId);
        }

        [WebMethod]
        public bool USER_ROLES_SAVE_ALL(string identity, int registryId, USER_ROLES[] userRoles)
        {
            return VIRPManager.USER_ROLES_SAVE_ALL(identity, registryId, userRoles);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/USER_ROLES_SAVE_ALL?identity={identity}&registryId={registryId}&userId={userId}&stdRegistryId={stdRegistryId}&userRoles={userRoles}")]
        public bool USER_ROLES_SAVE_ALL_XML(string identity, int registryId, USER_ROLES[] userRoles)
        {
            return this.USER_ROLES_SAVE_ALL(identity, registryId, userRoles);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/USER_ROLES_SAVE_ALL?identity={identity}&registryId={registryId}&userId={userId}&stdRegistryId={stdRegistryId}&userRoles={userRoles}")]
        public bool USER_ROLES_SAVE_ALL_JSON(string identity, int registryId, USER_ROLES[] userRoles)
        {
            return this.USER_ROLES_SAVE_ALL(identity, registryId, userRoles);
        }

        #endregion

        #region USERS

        [WebMethod]
        public USERS USERS_GET(string identity, int registryId, int id)
        {
            return VIRPManager.USERS_GET(identity, registryId, id);
        }

        [WebMethod]
        public List<USERS> USERS_GET_ALL(string identity, int registryId)
        {
            return VIRPManager.USERS_GET_ALL(identity, registryId);
        }

        [WebMethod]
        public int USERS_SAVE(string identity, int registryId, USERS objSave)
        {
            return VIRPManager.USERS_SAVE(identity, registryId, objSave);
        }

        [WebMethod]
        public Boolean USERS_DELETE(string identity, int registryId, int id)
        {
            return VIRPManager.USERS_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/USERS_GET?identity={identity}&registryId={registryId}&id={id}")]
        public USERS USERS_GET_XML(string identity, int registryId, int id)
        {
            return this.USERS_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/USERS_GET_ALL?identity={identity}&registryId={registryId}")]
        public List<USERS> USERS_GET_ALL_XML(string identity, int registryId)
        {
            return this.USERS_GET_ALL(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/USERS_SAVE?identity={identity}&registryId={registryId}")]
        public int USERS_SAVE_XML(string identity, int registryId, USERS objSave)
        {
            return this.USERS_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/USERS_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean USERS_DELETE_XML(string identity, int registryId, int id)
        {
            return this.USERS_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/USERS_GET?identity={identity}&registryId={registryId}&id={id}")]
        public USERS USERS_GET_JSON(string identity, int registryId, int id)
        {
            return this.USERS_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/USERS_GET_ALL?identity={identity}&registryId={registryId}")]
        public List<USERS> USERS_GET_ALL_JSON(string identity, int registryId)
        {
            return this.USERS_GET_ALL(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/USERS_SAVE?identity={identity}&registryId={registryId}")]
        public int USERS_SAVE_JSON(string identity, int registryId, USERS objSave)
        {
            return this.USERS_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/USERS_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean USERS_DELETE_JSON(string identity, int registryId, int id)
        {
            return this.USERS_DELETE(identity, registryId, id);
        }

        [WebMethod]
        public USERS USERS_GET_BY_NAME(string identity, int registryId, string username)
        {
            return VIRPManager.USERS_GET_BY_NAME(identity, registryId, username);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/USERS_GET_BY_NAME?identity={identity}&registryId={registryId}&username={username}")]
        public USERS USERS_GET_BY_NAME_XML(string identity, int registryId, string username)
        {
            return this.USERS_GET_BY_NAME(identity, registryId, username);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/USERS_GET_BY_NAME?identity={identity}&registryId={registryId}&username={username}")]
        public USERS USERS_GET_BY_NAME_JSON(string identity, int registryId, string username)
        {
            return this.USERS_GET_BY_NAME(identity, registryId, username);
        }

        [WebMethod]
        public bool USERS_DEFAULT_REGISTRY(string identity, int registryId, bool isDefault)
        {
            return VIRPManager.USERS_DEFAULT_REGISTRY(identity, registryId, isDefault);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/USERS_DEFAULT_REGISTRY?identity={identity}&registryId={registryId}&isDefault={isDefault}")]
        public bool USERS_DEFAULT_REGISTRY_XML(string identity, int registryId, bool isDefault)
        {
            return this.USERS_DEFAULT_REGISTRY(identity, registryId, isDefault);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/USERS_DEFAULT_REGISTRY?identity={identity}&registryId={registryId}&isDefault={isDefault}")]
        public bool USERS_DEFAULT_REGISTRY_JSON(string identity, int registryId, bool isDefault)
        {
            return this.USERS_DEFAULT_REGISTRY(identity, registryId, isDefault);
        }

        [WebMethod]
        public DomainNames USERS_LOAD_FROM_AD()
        {
            return VIRPManager.USERS_LOAD_FROM_AD();
        }

        [WebMethod]
        public List<DomainUser> USERS_GET_ALL_BY_AD(DomainNames domainNames, string searchString)
        {
            return VIRPManager.USERS_GET_ALL_BY_AD(domainNames, searchString);
        }

        [WebMethod]
        public List<USERS> USERS_GET_ALL_BY_USER(string identity, int registryId)
        {
            return VIRPManager.USERS_GET_ALL_BY_USER(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/USERS_LOAD_FROM_AD")]
        public DomainNames USERS_LOAD_FROM_AD_XML()
        {
            return this.USERS_LOAD_FROM_AD();
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/USERS_GET_ALL_BY_AD?domainNames={domainNames}&searchString={searchString}")]
        public List<DomainUser> USERS_GET_ALL_BY_AD_XML(DomainNames domainNames, string searchString)
        {
            return this.USERS_GET_ALL_BY_AD(domainNames, searchString);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/USERS_GET_ALL_BY_USER?identity={identity}&registryId={registryId}")]
        public List<USERS> USERS_GET_ALL_BY_USER_XML(string identity, int registryId)
        {
            return this.USERS_GET_ALL_BY_USER(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/USERS_LOAD_FROM_AD")]
        public DomainNames USERS_LOAD_FROM_AD_JSON()
        {
            return this.USERS_LOAD_FROM_AD();
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/USERS_GET_ALL_BY_AD?domainNames={domainNames}&searchString={searchString}")]
        public List<DomainUser> USERS_GET_ALL_BY_AD_JSON(DomainNames domainNames, string searchString)
        {
            return this.USERS_GET_ALL_BY_AD(domainNames, searchString);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/USERS_GET_ALL_BY_USER?identity={identity}&registryId={registryId}")]
        public List<USERS> USERS_GET_ALL_BY_USER_JSON(string identity, int registryId)
        {
            return this.USERS_GET_ALL_BY_USER(identity, registryId);
        }

        #endregion

        #region WKF_CASE

        [WebMethod]
        public WKF_CASE WKF_CASE_GET(string identity, int registryId, int id)
        {
            return VIRPManager.WKF_CASE_GET(identity, registryId, id);
        }

        [WebMethod]
        public WKF_CASE WKF_CASE_GET_BY_ACTIVITY(string identity, int registryId, int activityId)
        {
            return VIRPManager.WKF_CASE_GET_BY_ACTIVITY(identity, registryId, activityId);
        }

        [WebMethod]
        public List<WKF_CASE> WKF_CASE_GET_ALL_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.WKF_CASE_GET_ALL_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public LabOrderPatient LabOrderPatient_GET(string identity, int registryId, int activityId)
        {
            return VIRPManager.LabOrderPatient_GET(identity, registryId, activityId);
        }

        [WebMethod]
        public List<LabKitOrderGroup> KitOrderGroups_GET_ALL(string identity, int registryId)
        {
            return VIRPManager.KitOrderGroups_GET_ALL(identity, registryId);
        }

        [WebMethod]
        public List<LabKitOrderPatientsBO> LabKitOrders_GET_ALL(string identity, int registryId, Int32 institutionId, Int32 wkfCaseTypeId)
        {
            return VIRPManager.LabKitOrders_GET_ALL(identity, registryId, institutionId, wkfCaseTypeId);
        }

        [WebMethod]
        public int WKF_CASE_SAVE(string identity, int registryId, WKF_CASE objSave)
        {
            return VIRPManager.WKF_CASE_SAVE(identity, registryId, objSave);
        }

        [WebMethod]
        public Boolean WKF_CASE_DELETE(string identity, int registryId, int id)
        {
            return VIRPManager.WKF_CASE_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/WKF_CASE_GET?identity={identity}&registryId={registryId}&id={id}")]
        public WKF_CASE WKF_CASE_GET_XML(string identity, int registryId, int id)
        {
            return this.WKF_CASE_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/WKF_CASE_SAVE?identity={identity}&registryId={registryId}")]
        public int WKF_CASE_SAVE_XML(string identity, int registryId, WKF_CASE objSave)
        {
            return this.WKF_CASE_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/WKF_CASE_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean WKF_CASE_DELETE_XML(string identity, int registryId, int id)
        {
            return this.WKF_CASE_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/WKF_CASE_GET?identity={identity}&registryId={registryId}&id={id}")]
        public WKF_CASE WKF_CASE_GET_JSON(string identity, int registryId, int id)
        {
            return this.WKF_CASE_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/WKF_CASE_SAVE?identity={identity}&registryId={registryId}")]
        public int WKF_CASE_SAVE_JSON(string identity, int registryId, WKF_CASE objSave)
        {
            return this.WKF_CASE_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/WKF_CASE_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean WKF_CASE_DELETE_JSON(string identity, int registryId, int id)
        {
            return this.WKF_CASE_DELETE(identity, registryId, id);
        }

        [WebMethod]
        public List<WKF_CASE> WKF_CASE_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.WKF_CASE_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/WKF_CASE_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<WKF_CASE> WKF_CASE_GET_ALL_BY_REGISTRY_XML(string identity, int registryId)
        {
            return this.WKF_CASE_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/WKF_CASE_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<WKF_CASE> WKF_CASE_GET_ALL_BY_REGISTRY_JSON(string identity, int registryId)
        {
            return this.WKF_CASE_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [WebMethod]
        public bool WKF_CASE_UPDATE_STATUS(string identity, int registryId, int wkfCaseId, int statusId)
        {
            return VIRPManager.WKF_CASE_UPDATE_STATUS(identity, registryId, wkfCaseId, statusId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/WKF_CASE_UPDATE_STATUS?identity={identity}&registryId={registryId}&wkfCaseId={wkfCaseId}&statusId={statusId}")]
        public bool WKF_CASE_UPDATE_STATUS_XML(string identity, int registryId, int wkfCaseId, int statusId)
        {
            return this.WKF_CASE_UPDATE_STATUS(identity, registryId, wkfCaseId, statusId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/WKF_CASE_UPDATE_STATUS?identity={identity}&registryId={registryId}&wkfCaseId={wkfCaseId}&statusId={statusId}")]
        public bool WKF_CASE_UPDATE_STATUS_JSON(string identity, int registryId, int wkfCaseId, int statusId)
        {
            return this.WKF_CASE_UPDATE_STATUS(identity, registryId, wkfCaseId, statusId);
        }

        #endregion

        #region WKF_CASE_ACTIVITY

        [WebMethod]
        public WKF_CASE_ACTIVITY WKF_CASE_ACTIVITY_GET(string identity, int registryId, int id)
        {
            return VIRPManager.WKF_CASE_ACTIVITY_GET(identity, registryId, id);
        }

        [WebMethod]
        public int WKF_CASE_ACTIVITY_SAVE(string identity, int registryId, WKF_CASE_ACTIVITY objSave)
        {
            return VIRPManager.WKF_CASE_ACTIVITY_SAVE(identity, registryId, objSave);
        }

        [WebMethod]
        public int WKF_CASE_ACTIVITY_SAVEALL(string identity, int registryId, List<WKF_CASE_ACTIVITY> objSave)
        {
            return VIRPManager.WKF_CASE_ACTIVITY_SAVEALL(identity, registryId, objSave);
        }

        [WebMethod]
        public Boolean WKF_CASE_ACTIVITY_DELETE(string identity, int registryId, int id)
        {
            return VIRPManager.WKF_CASE_ACTIVITY_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/WKF_CASE_ACTIVITY_GET?identity={identity}&registryId={registryId}&id={id}")]
        public WKF_CASE_ACTIVITY WKF_CASE_ACTIVITY_GET_XML(string identity, int registryId, int id)
        {
            return this.WKF_CASE_ACTIVITY_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/WKF_CASE_ACTIVITY_SAVE?identity={identity}&registryId={registryId}")]
        public int WKF_CASE_ACTIVITY_SAVE_XML(string identity, int registryId, WKF_CASE_ACTIVITY objSave)
        {
            return this.WKF_CASE_ACTIVITY_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/WKF_CASE_ACTIVITY_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean WKF_CASE_ACTIVITY_DELETE_XML(string identity, int registryId, int id)
        {
            return this.WKF_CASE_ACTIVITY_DELETE(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/WKF_CASE_ACTIVITY_GET?identity={identity}&registryId={registryId}&id={id}")]
        public WKF_CASE_ACTIVITY WKF_CASE_ACTIVITY_GET_JSON(string identity, int registryId, int id)
        {
            return this.WKF_CASE_ACTIVITY_GET(identity, registryId, id);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/WKF_CASE_ACTIVITY_SAVE?identity={identity}&registryId={registryId}")]
        public int WKF_CASE_ACTIVITY_SAVE_JSON(string identity, int registryId, WKF_CASE_ACTIVITY objSave)
        {
            return this.WKF_CASE_ACTIVITY_SAVE(identity, registryId, objSave);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/WKF_CASE_ACTIVITY_DELETE?identity={identity}&registryId={registryId}&id={id}")]
        public Boolean WKF_CASE_ACTIVITY_DELETE_JSON(string identity, int registryId, int id)
        {
            return this.WKF_CASE_ACTIVITY_DELETE(identity, registryId, id);
        }

        [WebMethod]
        public List<KitOrders> KitOrders_GET_ALL(string identity, int registryId)
        {
            return VIRPManager.KitOrders_GET_ALL(identity, registryId);
        }

        [WebMethod]
        public List<LabResult> LabResult_GET_NEW(string identity, int registryId, int activityStatusId)
        {
            return VIRPManager.LabResult_GET_NEW(identity, registryId, activityStatusId);
        }

        [WebMethod]
        public List<WKF_CASE_ACTIVITY> WKF_CASE_ACTIVITY_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.WKF_CASE_ACTIVITY_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/WKF_CASE_ACTIVITY_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<WKF_CASE_ACTIVITY> WKF_CASE_ACTIVITY_GET_ALL_BY_REGISTRY_XML(string identity, int registryId)
        {
            return this.WKF_CASE_ACTIVITY_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/WKF_CASE_ACTIVITY_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<WKF_CASE_ACTIVITY> WKF_CASE_ACTIVITY_GET_ALL_BY_REGISTRY_JSON(string identity, int registryId)
        {
            return this.WKF_CASE_ACTIVITY_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [WebMethod]
        public List<WKF_CASE_ACTIVITY> WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(string identity, int registryId, int wkfCaseId)
        {
            return VIRPManager.WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(identity, registryId, wkfCaseId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM?identity={identity}&registryId={registryId}&wkfCaseId={wkfCaseId}")]
        public List<WKF_CASE_ACTIVITY> WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM_XML(string identity, int registryId, int wkfCaseId)
        {
            return this.WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(identity, registryId, wkfCaseId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM?identity={identity}&registryId={registryId}&wkfCaseId={wkfCaseId}")]
        public List<WKF_CASE_ACTIVITY> WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM_JSON(string identity, int registryId, int wkfCaseId)
        {
            return this.WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(identity, registryId, wkfCaseId);
        }

        [WebMethod]
        public List<LabOrderByStatus> WKF_CASE_ACTIVITY_GET_ALL_BY_STATUS(string identity, int registryId, int statusId)
        {
            return VIRPManager.WKF_CASE_ACTIVITY_GET_ALL_BY_STATUS(identity, registryId, statusId);
        }

        [WebMethod]
        public bool WKF_CASE_ACTIVITY_UPDATE_STATUS(string identity, int registryId, int wkfCaseActivityId, int statusId)
        {
            return VIRPManager.WKF_CASE_ACTIVITY_UPDATE_STATUS(identity, registryId, wkfCaseActivityId, statusId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/WKF_CASE_ACTIVITY_UPDATE_STATUS?identity={identity}&registryId={registryId}&wkfCaseActivityId={wkfCaseActivityId}&statusId={statusId}")]
        public bool WKF_CASE_ACTIVITY_UPDATE_STATUS_XML(string identity, int registryId, int wkfCaseActivityId, int statusId)
        {
            return this.WKF_CASE_ACTIVITY_UPDATE_STATUS(identity, registryId, wkfCaseActivityId, statusId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/WKF_CASE_ACTIVITY_UPDATE_STATUS?identity={identity}&registryId={registryId}&wkfCaseActivityId={wkfCaseActivityId}&statusId={statusId}")]
        public bool WKF_CASE_ACTIVITY_UPDATE_STATUS_JSON(string identity, int registryId, int wkfCaseActivityId, int statusId)
        {
            return this.WKF_CASE_ACTIVITY_UPDATE_STATUS(identity, registryId, wkfCaseActivityId, statusId);
        }

        #endregion

        #region LOGS

        [WebMethod]
        public void LOG_DETAILS(LogDetails logDetails)
        {
            VIRPManager.LOG_DETAILS(logDetails);
        }

        [WebMethod]
        public void LOG_TIMING(LogDetails logDetails)
        {
            VIRPManager.LOG_TIMING(logDetails);
        }

        [WebMethod]
        public void LOG_INFORMATION(string message, string processName, string username, int registryId)
        {
            VIRPManager.LOG_INFORMATION(message, processName, username, registryId);
        }

        [WebMethod]
        public void LOG_ERROR(string message, string processName, string username, int registryId)
        {
            VIRPManager.LOG_ERROR(message, processName, username, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/LOG_DETAILS?logDetails={logDetails}")]
        public void LOG_DETAILS_XML(LogDetails logDetails)
        {
            this.LOG_DETAILS(logDetails);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/LOG_TIMING?logDetails={logDetails}")]
        public void LOG_TIMING_XML(LogDetails logDetails)
        {
            this.LOG_TIMING(logDetails);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/LOG_INFORMATION?message={message}&processName={processName}&username={username}&registryId={registryId}")]
        public void LOG_INFORMATION_XML(string message, string processName, string username, int registryId)
        {
            this.LOG_INFORMATION(message, processName, username, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/LOG_ERROR?message={message}&processName={processName}&username={username}&registryId={registryId}")]
        public void LOG_ERROR_XML(string message, string processName, string username, int registryId)
        {
            this.LOG_ERROR(message, processName, username, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/LOG_DETAILS?logDetails={logDetails}")]
        public void LOG_DETAILS_JSON(LogDetails logDetails)
        {
            this.LOG_DETAILS(logDetails);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/LOG_TIMING?logDetails={logDetails}")]
        public void LOG_TIMING_JSON(LogDetails logDetails)
        {
            this.LOG_TIMING(logDetails);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/LOG_INFORMATION?message={message}&processName={processName}&username={username}&registryId={registryId}")]
        public void LOG_INFORMATION_JSON(string message, string processName, string username, int registryId)
        {
            this.LOG_INFORMATION(message, processName, username, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/LOG_ERROR?message={message}&processName={processName}&username={username}&registryId={registryId}")]
        public void LOG_ERROR_JSON(string message, string processName, string username, int registryId)
        {
            this.LOG_ERROR(message, processName, username, registryId);
        }

        #endregion

        #region REPORTS

        [WebMethod]
        public List<ReportItem> REPORTS_GET_ALL_BY_USER_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.REPORTS_GET_ALL_BY_USER_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REPORTS_GET_ALL_BY_USER_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<ReportItem> REPORTS_GET_ALL_BY_USER_REGISTRY_XML(string identity, int registryId)
        {
            return this.REPORTS_GET_ALL_BY_USER_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REPORTS_GET_ALL_BY_USER_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<ReportItem> REPORTS_GET_ALL_BY_USER_REGISTRY_JSON(string identity, int registryId)
        {
            return this.REPORTS_GET_ALL_BY_USER_REGISTRY(identity, registryId);
        }

        [WebMethod]
        public List<ReportItem> REPORTS_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.REPORTS_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REPORTS_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<ReportItem> REPORTS_GET_ALL_BY_REGISTRY_XML(string identity, int registryId)
        {
            return this.REPORTS_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REPORTS_GET_ALL_BY_REGISTRY?identity={identity}&registryId={registryId}")]
        public List<ReportItem> REPORTS_GET_ALL_BY_REGISTRY_JSON(string identity, int registryId)
        {
            return this.REPORTS_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [WebMethod]
        public List<ReportItem> REPORTS_GET_ALL_SYSTEM(string identity, int registryId)
        {
            return VIRPManager.REPORTS_GET_ALL_SYSTEM(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REPORTS_GET_ALL_SYSTEM?identity={identity}&registryId={registryId}")]
        public List<ReportItem> REPORTS_GET_ALL_SYSTEM_XML(string identity, int registryId)
        {
            return this.REPORTS_GET_ALL_SYSTEM(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REPORTS_GET_ALL_SYSTEM?identity={identity}&registryId={registryId}")]
        public List<ReportItem> REPORTS_GET_ALL_SYSTEM_JSON(string identity, int registryId)
        {
            return this.REPORTS_GET_ALL_SYSTEM(identity, registryId);
        }

        [WebMethod]
        public List<ReportItem> REPORTS_GET_ALL_BY_USER(string identity, int registryId)
        {
            return VIRPManager.REPORTS_GET_ALL_BY_USER(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REPORTS_GET_ALL_BY_USER?identity={identity}&registryId={registryId}")]
        public List<ReportItem> REPORTS_GET_ALL_BY_USER_XML(string identity, int registryId)
        {
            return this.REPORTS_GET_ALL_BY_USER(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REPORTS_GET_ALL_BY_USER?identity={identity}&registryId={registryId}")]
        public List<ReportItem> REPORTS_GET_ALL_BY_USER_JSON(string identity, int registryId)
        {
            return this.REPORTS_GET_ALL_BY_USER(identity, registryId);
        }

        [WebMethod]
        public bool REPORTS_UPDATE_ITEM_PROPERTIES(string identity, int registryId, string itemPath, string description)
        {
            return VIRPManager.REPORTS_UPDATE_ITEM_PROPERTIES(identity, registryId, itemPath, description);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/REPORTS_UPDATE_ITEM_PROPERTIES?identity={identity}&registryId={registryId}&itemPath={itemPath}&description={description}")]
        public bool REPORTS_UPDATE_ITEM_PROPERTIES_XML(string identity, int registryId, string itemPath, string description)
        {
            return this.REPORTS_UPDATE_ITEM_PROPERTIES(identity, registryId, itemPath, description);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/REPORTS_UPDATE_ITEM_PROPERTIES?identity={identity}&registryId={registryId}&itemPath={itemPath}&description={description}")]
        public bool REPORTS_UPDATE_ITEM_PROPERTIES_JSON(string identity, int registryId, string itemPath, string description)
        {
            return this.REPORTS_UPDATE_ITEM_PROPERTIES(identity, registryId, itemPath, description);
        }

        #endregion

        #region APPSETTINGS

        [WebMethod]
        public AppSettings APPSETTINGS_GET(string identity, int registryId)
        {
            AppSettings appSettings = new AppSettings();

            //if (WebConfigurationManager.ConnectionStrings["RegistryConnectionString"] != null)
            //{
            //    appSettings.ConnectionString = WebConfigurationManager.ConnectionStrings["RegistryConnectionString"].ConnectionString;
            //}

            if (WebConfigurationManager.AppSettings["SqlCommandTimeout"] != null)
            {
                int value = 0;
                int.TryParse(WebConfigurationManager.AppSettings["SqlCommandTimeout"], out value);
                appSettings.SqlCommandTimeout = value;
            }

            if (WebConfigurationManager.AppSettings["LogFileSize"] != null)
            {
                int value = 0;
                int.TryParse(WebConfigurationManager.AppSettings["LogFileSize"], out value);
                appSettings.LogFileSize = value;
            }

            if (WebConfigurationManager.AppSettings["LogFileArchive"] != null)
            {
                int value = 0;
                int.TryParse(WebConfigurationManager.AppSettings["LogFileArchive"], out value);
                appSettings.LogFileArchive = value;
            }

            if (WebConfigurationManager.AppSettings["LogErrors"] != null)
            {
                bool value = false;
                bool.TryParse(WebConfigurationManager.AppSettings["LogErrors"], out value);
                appSettings.LogErrors = value;
            }

            if (WebConfigurationManager.AppSettings["LogInformation"] != null)
            {
                bool value = false;
                bool.TryParse(WebConfigurationManager.AppSettings["LogInformation"], out value);
                appSettings.LogInformation = value;
            }

            if (WebConfigurationManager.AppSettings["LogTiming"] != null)
            {
                bool value = false;
                bool.TryParse(WebConfigurationManager.AppSettings["LogTiming"], out value);
                appSettings.LogTiming = value;
            }

            if (WebConfigurationManager.AppSettings["DatabaseLogEnabled"] != null)
            {
                bool value = false;
                bool.TryParse(WebConfigurationManager.AppSettings["DatabaseLogEnabled"], out value);
                appSettings.DatabaseLogEnabled = value;
            }

            if (WebConfigurationManager.AppSettings["EventLogEnabled"] != null)
            {
                bool value = false;
                bool.TryParse(WebConfigurationManager.AppSettings["EventLogEnabled"], out value);
                appSettings.EventLogEnabled = value;
            }

            if (WebConfigurationManager.AppSettings["FileLogEnabled"] != null)
            {
                bool value = false;
                bool.TryParse(WebConfigurationManager.AppSettings["FileLogEnabled"], out value);
                appSettings.FileLogEnabled = value;
            }

            appSettings.FileLogPath = WebConfigurationManager.AppSettings["FileLogPath"];

            if (WebConfigurationManager.AppSettings["MviEnabled"] != null)
            {
                bool value = false;
                bool.TryParse(WebConfigurationManager.AppSettings["MviEnabled"], out value);
                appSettings.MviEnabled = value;
            }

            appSettings.MviProcessingCode = WebConfigurationManager.AppSettings["MviProcessingCode"];
            appSettings.MviCertName = WebConfigurationManager.AppSettings["MviCertName"];
            appSettings.MviServiceUrl = WebConfigurationManager.AppSettings["MviServiceUrl"];

            appSettings.ViaRequestingApp = WebConfigurationManager.AppSettings["ViaRequestingApp"];
            appSettings.ViaServiceUrl = WebConfigurationManager.AppSettings["ViaServiceUrl"];
            appSettings.ViaAppToken = WebConfigurationManager.AppSettings["ViaAppToken"];
            appSettings.ViaAppKey = WebConfigurationManager.AppSettings["ViaAppKey"];

            appSettings.ReportServerUrl = WebConfigurationManager.AppSettings["ReportServerUrl"];
            appSettings.ReportServicePath = WebConfigurationManager.AppSettings["ReportServicePath"];
            appSettings.ReportBuilderPath = WebConfigurationManager.AppSettings["ReportBuilderPath"];

            appSettings.SSOiLogoutUrl = WebConfigurationManager.AppSettings["SSOiLogoutUrl"];

            SETTINGS setting = VIRPManager.SETTINGS_GET_REGISTRYNAME(identity, registryId, "EtlSchedule");
            if (setting != null)
                appSettings.EtlSchedule = setting.VALUE;

            setting = VIRPManager.SETTINGS_GET_REGISTRYNAME(identity, registryId, "EtlRetryAttempts");
            if (setting != null)
            {
                int value = 0;
                int.TryParse(setting.VALUE, out value);
                appSettings.EtlRetryAttempts = value;
            }

            setting = VIRPManager.SETTINGS_GET_REGISTRYNAME(identity, registryId, "EtlTimeBetweenAttempts");
            if (setting != null)
            {
                int value = 0;
                int.TryParse(setting.VALUE, out value);
                appSettings.EtlTimeBetweenAttempts = value;
            }

            setting = VIRPManager.SETTINGS_GET_REGISTRYNAME(identity, registryId, "HomePageText");
            if (setting != null)
                appSettings.HomePageText = setting.VALUE;

            return appSettings;
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/APPSETTINGS_GET?identity={identity}&registryId={registryId}")]
        public AppSettings APPSETTINGS_GET_XML(string identity, int registryId)
        {
            return this.APPSETTINGS_GET(identity, registryId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/APPSETTINGS_GET?identity={identity}&registryId={registryId}")]
        public AppSettings APPSETTINGS_GET_JSON(string identity, int registryId)
        {
            return this.APPSETTINGS_GET(identity, registryId);
        }

        [WebMethod]
        public void APPSETTINGS_SAVE_TO_CONFIG(AppSettings appSettings)
        {
            try
            {
                if (appSettings != null)
                {
                    Configuration myConfig = WebConfigurationManager.OpenWebConfiguration("~");
                    if (myConfig != null)
                    {
                        myConfig.AppSettings.Settings["SqlCommandTimeout"].Value = appSettings.SqlCommandTimeout.ToString();
                        myConfig.AppSettings.Settings["LogFileSize"].Value = appSettings.LogFileSize.ToString();
                        myConfig.AppSettings.Settings["LogFileArchive"].Value = appSettings.LogFileArchive.ToString();
                        myConfig.AppSettings.Settings["LogErrors"].Value = appSettings.LogErrors.ToString();
                        myConfig.AppSettings.Settings["LogInformation"].Value = appSettings.LogInformation.ToString();
                        myConfig.AppSettings.Settings["LogTiming"].Value = appSettings.LogTiming.ToString();
                        myConfig.AppSettings.Settings["DatabaseLogEnabled"].Value = appSettings.DatabaseLogEnabled.ToString();
                        myConfig.AppSettings.Settings["EventLogEnabled"].Value = appSettings.EventLogEnabled.ToString();
                        myConfig.AppSettings.Settings["FileLogEnabled"].Value = appSettings.FileLogEnabled.ToString();
                        myConfig.AppSettings.Settings["FileLogPath"].Value = appSettings.FileLogPath;
                        myConfig.AppSettings.Settings["MviEnabled"].Value = appSettings.MviEnabled.ToString();
                        myConfig.AppSettings.Settings["MviProcessingCode"].Value = appSettings.MviProcessingCode;
                        myConfig.AppSettings.Settings["MviCertName"].Value = appSettings.MviCertName;
                        myConfig.AppSettings.Settings["MviServiceUrl"].Value = appSettings.MviServiceUrl;
                        myConfig.AppSettings.Settings["ReportServerUrl"].Value = appSettings.ReportServerUrl;
                        myConfig.AppSettings.Settings["ReportServicePath"].Value = appSettings.ReportServicePath;
                        myConfig.AppSettings.Settings["ReportBuilderPath"].Value = appSettings.ReportBuilderPath;
                        myConfig.AppSettings.Settings["SSOiLogoutUrl"].Value = appSettings.SSOiLogoutUrl;
                        myConfig.AppSettings.Settings["SSOiLogoutUrl"].Value = appSettings.SSOiLogoutUrl;

                        if (myConfig.AppSettings.Settings["ViaRequestingApp"] != null)
                            myConfig.AppSettings.Settings["ViaRequestingApp"].Value = appSettings.ViaRequestingApp;
                        else
                            myConfig.AppSettings.Settings.Add("ViaRequestingApp", appSettings.ViaRequestingApp);

                        if (myConfig.AppSettings.Settings["ViaServiceUrl"] != null)
                            myConfig.AppSettings.Settings["ViaServiceUrl"].Value = appSettings.ViaServiceUrl;
                        else
                            myConfig.AppSettings.Settings.Add("ViaServiceUrl", appSettings.ViaServiceUrl);

                        if (myConfig.AppSettings.Settings["ViaAppToken"] != null)
                            myConfig.AppSettings.Settings["ViaAppToken"].Value = appSettings.ViaAppToken;
                        else
                            myConfig.AppSettings.Settings.Add("ViaAppToken", appSettings.ViaAppToken);

                        if (myConfig.AppSettings.Settings["ViaAppKey"] != null)
                            myConfig.AppSettings.Settings["ViaAppKey"].Value = appSettings.ViaAppKey;
                        else
                            myConfig.AppSettings.Settings.Add("ViaAppKey", appSettings.ViaAppKey);

                        myConfig.Save(ConfigurationSaveMode.Modified);
                    }
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }
        }

        [WebMethod]
        public bool APPSETTINGS_SAVE(string identity, int registryId, AppSettings appSettings)
        {
            bool saveConfig = false;
            bool saveDb = false;

            if (appSettings != null)
            {
                //Configuration myConfig = WebConfigurationManager.OpenWebConfiguration("~");
                //if (myConfig != null)
                //{
                try
                {
                    APPSETTINGS_SAVE_TO_CONFIG(appSettings);
                    saveConfig = true;
                }
                catch //(Exception ex)
                {
                    //Error has already been logged
                    saveConfig = false;
                }

                try
                {
                    VIRPManager.SETTINGS_SAVE_ALL(identity, registryId, appSettings);
                    saveDb = true;
                }
                catch //(Exception ex)
                {
                    //Error has already been logged
                    saveDb = false;
                }
                //}
            }

            if (saveConfig && saveDb)
                return true;
            else
                return false;
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/APPSETTINGS_SAVE?identity={identity}&registryId={registryId}&appSettings={appSettings}")]
        public bool APPSETTINGS_SAVE_XML(string identity, int registryId, AppSettings appSettings)
        {
            return this.APPSETTINGS_SAVE(identity, registryId, appSettings);
        }

        [OperationContract]
        [WebInvoke(Method = "PUT", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/APPSETTINGS_SAVE?identity={identity}&registryId={registryId}&appSettings={appSettings}")]
        public bool APPSETTINGS_SAVE_JSON(string identity, int registryId, AppSettings appSettings)
        {
            return this.APPSETTINGS_SAVE(identity, registryId, appSettings);
        }

        [WebMethod]
        public string REPORTS_GET_SERVER_URL()
        {
            string reportServerUrl = string.Empty; //Default

            if (!string.IsNullOrEmpty(ConfigurationManager.AppSettings["ReportServerUrl"]))
            {
                reportServerUrl = ConfigurationManager.AppSettings["ReportServerUrl"];
            }

            return reportServerUrl;
        }

        [WebMethod]
        public string REPORTS_GET_BUILDER_URL()
        {
            string reportBuilderServerUrl = string.Empty; //Default

            if (!string.IsNullOrEmpty(ConfigurationManager.AppSettings["ReportServerUrl"]))
            {
                reportBuilderServerUrl = ConfigurationManager.AppSettings["ReportServerUrl"];
                if (!string.IsNullOrEmpty(ConfigurationManager.AppSettings["ReportBuilderPath"]))
                {
                    reportBuilderServerUrl += ConfigurationManager.AppSettings["ReportBuilderPath"];
                }
            }

            return reportBuilderServerUrl;
        }

        [WebMethod]
        public int GET_SQL_COMMAND_TIMEOUT()
        {
            int iTimeout = 30; //Default

            if (int.Parse(ConfigurationManager.AppSettings["SqlCommandTimeout"]) != iTimeout)
            {
                iTimeout = int.Parse(ConfigurationManager.AppSettings["SqlCommandTimeout"]);
            }

            return iTimeout;
        }

        #endregion

        #region FRAMEWORK_DATA

        [WebMethod]
        public List<ENC_ENCOUNTER> ENC_ENCOUNTER_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.ENC_ENCOUNTER_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/ENC_ENCOUNTER_GET_BY_REFERRAL?identity={identity}&registryId={registryId}&referralId={referralId}")]
        public List<ENC_ENCOUNTER> ENC_ENCOUNTER_GET_BY_REFERRAL_XML(string identity, int registryId, int referralId)
        {
            return this.ENC_ENCOUNTER_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/ENC_ENCOUNTER_GET_BY_REFERRAL?identity={identity}&registryId={registryId}&referralId={referralId}")]
        public List<ENC_ENCOUNTER> ENC_ENCOUNTER_GET_BY_REFERRAL_JSON(string identity, int registryId, int referralId)
        {
            return this.ENC_ENCOUNTER_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<OUTPAT_VISIT> OUTPAT_VISIT_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.OUTPAT_VISIT_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/OUTPAT_VISIT_GET_BY_REFERRAL?identity={identity}&registryId={registryId}&referralId={referralId}")]
        public List<OUTPAT_VISIT> OUTPAT_VISIT_GET_BY_REFERRAL_XML(string identity, int registryId, int referralId)
        {
            return this.OUTPAT_VISIT_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/OUTPAT_VISIT_GET_BY_REFERRAL?identity={identity}&registryId={registryId}&referralId={referralId}")]
        public List<OUTPAT_VISIT> OUTPAT_VISIT_GET_BY_REFERRAL_JSON(string identity, int registryId, int referralId)
        {
            return this.OUTPAT_VISIT_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public string GET_VERSION()
        {
            return VIRPManager.GET_VERSION();
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/GET_VERSION")]
        public string GET_VERSION_XML(string identity, int registryId, int referralId)
        {
            return this.GET_VERSION();
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/GET_VERSION")]
        public string GET_VERSION_JSON(string identity, int registryId, int referralId)
        {
            return this.GET_VERSION();
        }

        [WebMethod]
        public List<TableColumnValue> REGISTRY_FRAMEWORK_TABLE_GET_ALL_BY_REGISTRY(string identity, int registryId, int referralId, int patientId, string frameworkTable)
        {
            return VIRPManager.REGISTRY_FRAMEWORK_TABLE_GET_ALL_BY_REGISTRY(identity, registryId, referralId, patientId, frameworkTable);
        }

        [WebMethod]
        public List<TableColumnValue> REGISTRY_FRAMEWORK_DATA_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return VIRPManager.REGISTRY_FRAMEWORK_DATA_GET_ALL_BY_REGISTRY(identity, registryId);
        }

        [WebMethod]
        public List<ALLERGY> ALLERGY_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.ALLERGY_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<A06_AUDIOMETRIC_EXAM_DATA_509850_9> A06_AUDIOMETRIC_EXAM_DATA_509850_9_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.A06_AUDIOMETRIC_EXAM_DATA_509850_9_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<CONSULT> CONSULT_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.CONSULT_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<EDISLOG> EDISLOG_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.EDISLOG_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<IMMUNIZATION> IMMUNIZATION_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.IMMUNIZATION_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<INPAT_INPATIENT> INPAT_INPATIENT_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.INPAT_INPATIENT_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<INPAT_CENSUS> INPAT_CENSUS_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.INPAT_CENSUS_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<INPATIENT_DIAGNOSIS> INPATIENT_DIAGNOSIS_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.INPATIENT_DIAGNOSIS_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<CHEM_LABCHEM> CHEM_LABCHEM_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.CHEM_LABCHEM_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        //[WebMethod]
        //public List<OUTPAT_VISIT> OUTPAT_VISIT_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        //{
        //    return VIRPManager.OUTPAT_VISIT_GET_BY_REFERRAL(identity, registryId, referralId);
        //}

        [WebMethod]
        public List<SCONSULT_REASON> SCONSULT_REASON_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.SCONSULT_REASON_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<PATSUB_SECONDARYELIGIBILITY> PATSUB_SECONDARYELIGIBILITY_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.PATSUB_SECONDARYELIGIBILITY_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<PATIENT_ENROLLMENT> PATIENT_ENROLLMENT_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.PATIENT_ENROLLMENT_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<PATIENT_ETHNICITY> PATIENT_ETHNICITY_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.PATIENT_ETHNICITY_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<A06_SPATIENT_GEOCODEDADDRESS> A06_SPATIENT_GEOCODEDADDRESS_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.A06_SPATIENT_GEOCODEDADDRESS_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<SPATIENT_SPATIENTINSURANCE> SPATIENT_SPATIENTINSURANCE_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.SPATIENT_SPATIENTINSURANCE_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<MILITARY_SERVICE_EPISODE> MILITARY_SERVICE_EPISODE_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.MILITARY_SERVICE_EPISODE_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<MILITARY_SEXUAL_TRAUMA> MILITARY_SEXUAL_TRAUMA_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.MILITARY_SEXUAL_TRAUMA_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<OEFOIF_SERVICE> OEFOIF_SERVICE_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.OEFOIF_SERVICE_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<PHARMACY_PATIENT> PHARMACY_PATIENT_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.PHARMACY_PATIENT_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<NOSETHROAT_RADIUMHST> NOSETHROAT_RADIUMHST_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.NOSETHROAT_RADIUMHST_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<SERVICE_CONNECTED_CONDITION> SERVICE_CONNECTED_CONDITION_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.SERVICE_CONNECTED_CONDITION_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<PATSUB_VARATEDDISABILITY> PATSUB_VARATEDDISABILITY_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.PATSUB_VARATEDDISABILITY_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<A06_PHARMACY_PATIENT_55X_IV_55_01> A06_PHARMACY_PATIENT_55X_IV_55_01_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.A06_PHARMACY_PATIENT_55X_IV_55_01_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<A06_PHARMACY_PATIX_UNIT_DOSE_55_06> A06_PHARMACY_PATIX_UNIT_DOSE_55_06_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.A06_PHARMACY_PATIX_UNIT_DOSE_55_06_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<A06_PHARMACY_PATX_NONVA_MEDS_55_05> A06_PHARMACY_PATX_NONVA_MEDS_55_05_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.A06_PHARMACY_PATX_NONVA_MEDS_55_05_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<RXOUTPAT> RXOUTPAT_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.RXOUTPAT_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<OUTPAT_PROBLEMLIST> OUTPAT_PROBLEMLIST_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.OUTPAT_PROBLEMLIST_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<TIU_TIUDOCUMENT> TIU_TIUDOCUMENT_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.TIU_TIUDOCUMENT_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<RADIOLOGYEXAM> RADIOLOGYEXAM_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.RADIOLOGYEXAM_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<SPATIENT_NEW> SPATIENT_NEW_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.SPATIENT_NEW_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<OUTPAT_VDIAGNOSIS> OUTPAT_VDIAGNOSIS_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.OUTPAT_VDIAGNOSIS_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<VITALSIGN> VITALSIGN_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.VITALSIGN_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<PATSUB_PATIENTRACE> PATSUB_PATIENTRACE_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.PATSUB_PATIENTRACE_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<LabScreening> LABSCREENING_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.LABSCREENING_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<TRACER> TRACER_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.TRACER_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<APPT_APPOINTMENT> APPOINTMENTS_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.APPOINTMENTS_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        [WebMethod]
        public List<PATIENT_PROVIDER> PATIENT_PROVIDER_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return PATIENT_PROVIDERManager.GetItemsByReferral(identity, registryId, referralId);
        }

        [WebMethod]
        public object GetFrameWorkInfo(string identity, int registryId, int referralId, int patientId, string frameworkTable)
        {
            return FrameworkdataManager.GetFrameWorkInfo(identity, registryId, referralId, patientId, frameworkTable);
        }

        #endregion

        #region AHOBPR
        [WebMethod]
        public List<VIRP.AHOBPR.BO.TOOL_QUESTION_DTO> SearchQuestions(string keyWords, string type, string status, string sort, int startRow, int maxRows, ref int totalCount)
        {
            var result = new VIRP.AHOBPR.BLL.AHOBPRToolManager().SearchQuestions(keyWords, type, status, sort, startRow, maxRows, ref totalCount).ToList()
                .Select(x => new VIRP.AHOBPR.BO.TOOL_QUESTION_DTO()
                {
                    ACTIVE_FLAG = x.ACTIVE_FLAG,
                    CREATED = x.CREATED,
                    CREATEDBY = x.CREATEDBY,
                    EDITABLE_FLAG = x.EDITABLE_FLAG,
                    KEY_WORDS = x.KEY_WORDS,
                    MAX = x.MAX,
                    MAX_CHOICES = x.MAX_CHOICES,
                    MAX_LENGTH = x.MAX_LENGTH,
                    MIN = x.MIN,
                    MIN_LENGTH = x.MIN_LENGTH,
                    SOURCE_ID = x.SOURCE_ID,
                    Status = x.Status,
                    TEXT = x.TEXT,
                    TOOL_QUESTION_ID = x.TOOL_QUESTION_ID,
                    TYPE = x.TYPE,
                    UPDATED = x.UPDATED,
                    UPDATEDBY = x.UPDATEDBY
                });

            return result.ToList();
        }

        [WebMethod]
        public List<VIRP.AHOBPR.BO.TOOL_FORM_DTO> SearchForms(string keyWords, string status, string systemWide, string sort, int startRow, int maxRows, ref int totalCount)
        {
            var result = new VIRP.AHOBPR.BLL.AHOBPRToolManager().SearchForms(keyWords, status, systemWide, sort, startRow, maxRows, ref totalCount).ToList()
                .Select(x => new VIRP.AHOBPR.BO.TOOL_FORM_DTO()
                {
                    ACTIVE_FLAG = x.ACTIVE_FLAG,
                    CREATED = x.CREATED,
                    CREATEDBY = x.CREATEDBY,
                    EDITABLE_FLAG = x.EDITABLE_FLAG,
                    NAME = x.NAME,
                    SYSTEM_WIDE_FLAG = x.SYSTEM_WIDE_FLAG,
                    TITLE = x.TITLE,
                    TOOL_FORM_ID = x.TOOL_FORM_ID,
                    UPDATED = x.UPDATED,
                    UPDATEDBY = x.UPDATEDBY,
                    Status = x.Status           
                });

            return result.ToList();
        }

        [WebMethod]
        public VIRP.AHOBPR.BO.TOOL_FORM_DTO GetFormById(int formId)
        {
            var result = new VIRP.AHOBPR.BLL.AHOBPRToolManager().GetFormById(formId);

            return result;
        }

        [WebMethod]
        public VIRP.AHOBPR.BO.TOOL_QUESTION_DTO GetQuestionById(int questionId)
        {
            var result = new VIRP.AHOBPR.BLL.AHOBPRToolManager().GetQuestionById(questionId);

            return result;
        }

        [WebMethod]
        public List<VIRP.AHOBPR.BO.TOOL_QUESTION_DTO> GetQuestionsByFormId(int formId)
        {
            var result = new VIRP.AHOBPR.BLL.AHOBPRToolManager().GetQuestionsByFormId(formId).ToList()
                .Select(x => new VIRP.AHOBPR.BO.TOOL_QUESTION_DTO()
                {
                    ACTIVE_FLAG = x.ACTIVE_FLAG,
                    CREATED = x.CREATED,
                    CREATEDBY = x.CREATEDBY,
                    EDITABLE_FLAG = x.EDITABLE_FLAG,
                    KEY_WORDS = x.KEY_WORDS,
                    MAX = x.MAX,
                    MAX_CHOICES = x.MAX_CHOICES,
                    MAX_LENGTH = x.MAX_LENGTH,
                    MIN = x.MIN,
                    MIN_LENGTH = x.MIN_LENGTH,
                    SOURCE_ID = x.SOURCE_ID,
                    Status = x.Status,
                    TEXT = x.TEXT,
                    TOOL_QUESTION_ID = x.TOOL_QUESTION_ID,
                    TYPE = x.TYPE,
                    UPDATED = x.UPDATED,
                    UPDATEDBY = x.UPDATEDBY
                });

            return result.ToList();
        }

        [WebMethod]
        public int AddQuestionToForm(string CURRENT_USER, int questionId, int formId)
        {
            return new VIRP.AHOBPR.BLL.AHOBPRToolManager().AddQuestionToForm(CURRENT_USER, questionId, formId);
        }

        [WebMethod]
        public bool RemoveQuestionFromForm(string CURRENT_USER, int questionId, int formId)
        {
            return new VIRP.AHOBPR.BLL.AHOBPRToolManager().RemoveQuestionFromForm(CURRENT_USER, questionId, formId);
        }

        [WebMethod]
        public int SaveForm(string currentUser, int formId, VIRP.AHOBPR.BO.TOOL_FORM_DTO saveForm)
        {
            return new VIRP.AHOBPR.BLL.AHOBPRToolManager().SaveForm(currentUser, formId, saveForm);
        }

        [WebMethod]
        public void SubmitFollowUpFormToStdTables(string currentUser, int toolFormId)
        {
            new VIRP.AHOBPR.BLL.AHOBPRToolManager().SubmitFollowUpFormToStdTables(currentUser, toolFormId);
        }

        [WebMethod]
        public bool RemoveForm(int formId)
        {
            return new VIRP.AHOBPR.BLL.AHOBPRToolManager().RemoveForm(formId);
        }

        [WebMethod]
        public List<VIRP.AHOBPR.BO.VIEW_LOOKUP> SelectLookupList(string lookupCategory)
        {
            return new VIRP.AHOBPR.BLL.AHOBPRBaseControlManager().SelectLookupList(lookupCategory);
        }

        [WebMethod]
        public int SaveQuestion(string currentUser, int questionId, VIRP.AHOBPR.BO.TOOL_QUESTION_DTO saveQuestion)
        {
            return new VIRP.AHOBPR.BLL.AHOBPRToolManager().SaveQuestion(currentUser, questionId, saveQuestion);
        }

        [WebMethod]
        public bool ActivateDeactivateForm(string currentUser, int formId)
        {
            return new VIRP.AHOBPR.BLL.AHOBPRToolManager().ActivateDeactivateForm(currentUser, formId);
        }

        [WebMethod]
        public bool ActivateDeactivateQuestion(string currentUser, int questionId)
        {
            return new VIRP.AHOBPR.BLL.AHOBPRToolManager().ActivateDeactivateQuestion(currentUser, questionId);
        }

        [WebMethod]
        public bool RemoveQuestion(int questionId)
        {
            return new VIRP.AHOBPR.BLL.AHOBPRToolManager().RemoveQuestion(questionId);
        }

        [WebMethod]
        public List<STD_GUI_CONTROLS> STD_GUI_CONTROLS_GetByCategory(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string category)
        {
            return STD_GUI_CONTROLSManager.GetByCategory(CURRENT_USER, CURRENT_REGISTRY_ID, category);
        }

        #region TOOL_FORM
        [WebMethod]
        public static Int32 TOOL_FORM_Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, VIRP.AHOBPR.BO.TOOL_FORM objSave)
        {
            return VIRP.AHOBPR.BLL.TOOL_FORMManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }
        #endregion

        #endregion
        #region AHOBPR USERS

        [WebMethod]
        public AHOBPR_USER AHOBPRUSERS_GET(string identity, int registryId, int id)
        {
            return VIRPManager.AHOBPRUSERS_GET(identity, registryId, id);
        }

        [WebMethod]
        public int AHOBPRUSERS_SAVE(string identity, int registryId, AHOBPR_USER objSave)
        {
            return VIRPManager.AHOBPRUSERS_SAVE(identity, registryId, objSave);
        }

        [WebMethod]
        public int SaveUserStateFilter(string identity, int registryId, USER_STATES_FILTER objSave)
        {
            return VIRPManager.SaveUserStateFilter(identity, registryId, objSave);
        }

        [WebMethod]
        public USER_STATES_FILTER GetStatesFilter(string identity, int registryId, int id)
        {
            return VIRPManager.GetStatesFilter(identity, registryId, id);
        }
        #endregion

        #region AUDIT_LOG
        [WebMethod]
        public Int32 AUDIT_LOG_Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, AUDIT_LOG objSave)
        {
            return AUDIT_LOGManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }
        #endregion
    }
}
